/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.r2dbc;

import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseResponseSummary;
import com.clickhouse.data.ClickHouseRecord;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import com.clickhouse.r2dbc.ClickHousePair;
import com.clickhouse.r2dbc.ClickHouseRow;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ClickHouseResult
implements Result {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseResult.class);
    private final Flux<? extends Result.Segment> rowSegments;
    private final Mono<? extends Result.Segment> updatedCount;
    private final Flux<? extends Result.Segment> segments;

    ClickHouseResult(ClickHouseResponse response) {
        this.rowSegments = Mono.just((Object)response).flatMapMany(resp -> Flux.fromStream(StreamSupport.stream(resp.records().spliterator(), false).map((? super T rec) -> ClickHousePair.of(resp.getColumns(), rec)))).map(pair -> new ClickHouseRow((ClickHouseRecord)pair.getRight(), (List)pair.getLeft())).map(x$0 -> new RowSegment((ClickHouseRow)x$0));
        this.updatedCount = Mono.just((Object)response).map(ClickHouseResponse::getSummary).map(ClickHouseResponseSummary::getProgress).map(ClickHouseResponseSummary.Progress::getWrittenRows).map(x$0 -> new UpdateCount((long)x$0));
        this.segments = Flux.concat((Publisher[])new Publisher[]{this.updatedCount, this.rowSegments});
    }

    ClickHouseResult(Flux<? extends Result.Segment> rowSegments, Mono<? extends Result.Segment> updatedCount) {
        this.rowSegments = rowSegments;
        this.updatedCount = updatedCount;
        this.segments = Flux.concat((Publisher[])new Publisher[]{this.updatedCount, this.rowSegments});
    }

    public Mono<Long> getRowsUpdated() {
        return this.updatedCount.map(val -> ((UpdateCount)val).value());
    }

    public <T> Publisher<T> map(BiFunction<Row, RowMetadata, ? extends T> biFunction) {
        return this.rowSegments.cast(RowSegment.class).map(RowSegment::row).handle((row, sink) -> {
            try {
                sink.next(biFunction.apply((Row)row, row.getMetadata()));
            }
            catch (Exception e) {
                log.error((Object)"Provided function caused exception:", (Throwable)e);
            }
        });
    }

    public Result filter(Predicate<Result.Segment> predicate) {
        return new ClickHouseResult((Flux<? extends Result.Segment>)this.segments.filter(predicate), (Mono<? extends Result.Segment>)this.updatedCount.filter(predicate));
    }

    public <T> Publisher<T> flatMap(Function<Result.Segment, ? extends Publisher<? extends T>> function) {
        return this.segments.flatMap(segment -> {
            try {
                Publisher retValue = (Publisher)function.apply((Result.Segment)segment);
                if (retValue == null) {
                    return Mono.error((Throwable)new IllegalStateException("flatmap function returned null value"));
                }
                return retValue;
            }
            catch (Exception e) {
                log.error((Object)"Provided function caused exception:", (Throwable)e);
                return Mono.error((Throwable)e);
            }
        });
    }

    class RowSegment
    implements Result.RowSegment {
        final ClickHouseRow row;

        RowSegment(ClickHouseRow row) {
            this.row = row;
        }

        public Row row() {
            return this.row;
        }
    }

    class UpdateCount
    implements Result.UpdateCount {
        final long updateCount;

        UpdateCount(long updateCount) {
            this.updateCount = updateCount;
        }

        public long value() {
            return this.updateCount;
        }
    }
}

