/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.r2dbc.connection;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseNodeSelector;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.data.ClickHouseFormat;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import com.clickhouse.r2dbc.ClickHouseBatch;
import com.clickhouse.r2dbc.ClickHouseStatement;
import com.clickhouse.r2dbc.connection.ClickHouseConnectionMetadata;
import io.r2dbc.spi.Batch;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionMetadata;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.Statement;
import io.r2dbc.spi.TransactionDefinition;
import io.r2dbc.spi.ValidationDepth;
import java.io.Serializable;
import java.time.Duration;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class ClickHouseConnection
implements Connection {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseConnection.class);
    private static final String PRODUCT_NAME = "ClickHouse-R2dbcDriver";
    public static final int DEFAULT_TIMEOUT_FOR_CONNECTION_HEALTH_CHECK = (Integer)ClickHouseClientOption.CONNECTION_TIMEOUT.getDefaultValue();
    final ClickHouseClient client;
    final ClickHouseNode node;
    private boolean closed = false;

    ClickHouseConnection(Function<ClickHouseNodeSelector, ClickHouseNode> nodes) {
        this.node = nodes.apply(ClickHouseNodeSelector.EMPTY);
        ClickHouseConfig config = this.node.getConfig();
        this.client = ClickHouseClient.builder().option(ClickHouseClientOption.FORMAT, (Serializable)((Object)ClickHouseFormat.RowBinaryWithNamesAndTypes)).config(config).nodeSelector(ClickHouseNodeSelector.of(this.node.getProtocol(), new ClickHouseProtocol[0])).build();
    }

    public Mono<Void> beginTransaction() {
        log.debug((Object)"Clickhouse does not support transactions so skipping initialization of transaction.", new Object[0]);
        return Mono.empty();
    }

    public Mono<Void> beginTransaction(TransactionDefinition transactionDefinition) {
        log.debug((Object)"Clickhouse does not support transactions so skipping initialization of transaction.", new Object[0]);
        return Mono.empty();
    }

    public Publisher<Void> close() {
        try {
            this.client.close();
            this.closed = true;
            return Mono.empty();
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    public Publisher<Void> commitTransaction() {
        log.debug((Object)"Clickhouse does not support transactions so skipping commit of transaction.", new Object[0]);
        return Mono.empty();
    }

    public Batch createBatch() {
        Object req = this.client.read(this.node).option(ClickHouseClientOption.PRODUCT_NAME, (Serializable)((Object)PRODUCT_NAME));
        if (this.isHttp()) {
            req = ((ClickHouseRequest)req).set("send_progress_in_http_headers", Integer.valueOf(1));
        }
        ((ClickHouseRequest)req).option(ClickHouseClientOption.ASYNC, Boolean.valueOf(true));
        return new ClickHouseBatch((ClickHouseRequest<?>)req);
    }

    public Publisher<Void> createSavepoint(String s) {
        return Mono.empty();
    }

    public Statement createStatement(String sql) {
        Object req = this.client.read(this.node).option(ClickHouseClientOption.PRODUCT_NAME, (Serializable)((Object)PRODUCT_NAME));
        if (this.isHttp()) {
            req = ((ClickHouseRequest)req).set("send_progress_in_http_headers", Integer.valueOf(1));
        }
        ((ClickHouseRequest)req).option(ClickHouseClientOption.ASYNC, Boolean.valueOf(true));
        return new ClickHouseStatement(sql, (ClickHouseRequest<?>)req);
    }

    private boolean isHttp() {
        return this.node.getProtocol() == ClickHouseProtocol.HTTP;
    }

    public boolean isAutoCommit() {
        return true;
    }

    public ConnectionMetadata getMetadata() {
        return new ClickHouseConnectionMetadata(this.client, this.node);
    }

    public IsolationLevel getTransactionIsolationLevel() {
        return IsolationLevel.READ_COMMITTED;
    }

    public Publisher<Void> releaseSavepoint(String s) {
        return null;
    }

    public Publisher<Void> rollbackTransaction() {
        log.debug((Object)"Clickhouse does not support transactions so skipping rollback of transaction.", new Object[0]);
        return Mono.empty();
    }

    public Publisher<Void> rollbackTransactionToSavepoint(String s) {
        return null;
    }

    public Publisher<Void> setAutoCommit(boolean b) {
        log.debug((Object)"Clickhouse does not support transactions so skipping setting of transaction auto commit.", new Object[0]);
        return Mono.empty();
    }

    public Publisher<Void> setLockWaitTimeout(Duration duration) {
        return null;
    }

    public Publisher<Void> setStatementTimeout(Duration duration) {
        return null;
    }

    public Mono<Void> setTransactionIsolationLevel(IsolationLevel isolationLevel) {
        return Mono.error((Throwable)new UnsupportedOperationException("Transaction isolation level can not be changed."));
    }

    public Publisher<Boolean> validate(ValidationDepth validationDepth) {
        if (validationDepth == ValidationDepth.REMOTE) {
            return this.closed ? Mono.just((Object)false) : Mono.just((Object)this.client.ping(this.node, DEFAULT_TIMEOUT_FOR_CONNECTION_HEALTH_CHECK));
        }
        return Mono.just((Object)(this.client != null && !this.closed ? 1 : 0));
    }
}

