/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.r2dbc.connection;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseNodes;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseDefaults;
import com.clickhouse.config.ClickHouseOption;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.r2dbc.connection.ClickHouseConnectionFactory;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.ConnectionFactoryProvider;
import io.r2dbc.spi.Option;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ServiceLoader;

public class ClickHouseConnectionFactoryProvider
implements ConnectionFactoryProvider {
    public static final String CLICKHOUSE_DRIVER = "clickhouse";
    public static final Option<String> FORMAT = Option.valueOf((String)ClickHouseClientOption.FORMAT.getKey());
    private static final List<Option<?>> connQueryParams;

    private String getOptionValueAsString(ConnectionFactoryOptions cfOpt, Option<?> option, Serializable defaultValue) {
        Object value = cfOpt.getValue(option);
        return value != null ? value.toString() : defaultValue.toString();
    }

    private String getHosts(ConnectionFactoryOptions cfOpt) {
        String hosts = this.getOptionValueAsString(cfOpt, ConnectionFactoryOptions.HOST, ClickHouseDefaults.HOST.getEffectiveDefaultValue());
        if (!hosts.contains(",") && !hosts.contains(":")) {
            return hosts + ":" + cfOpt.getValue(ConnectionFactoryOptions.PORT);
        }
        return hosts;
    }

    public ConnectionFactory create(ConnectionFactoryOptions cfOpt) {
        String hosts = this.getHosts(cfOpt);
        String database = this.getOptionValueAsString(cfOpt, ConnectionFactoryOptions.DATABASE, (Serializable)((Object)""));
        String protocol = this.getOptionValueAsString(cfOpt, ConnectionFactoryOptions.PROTOCOL, (Serializable)((Object)ClickHouseProtocol.HTTP.name())).toLowerCase(Locale.ROOT);
        if (Boolean.parseBoolean(this.getOptionValueAsString(cfOpt, ConnectionFactoryOptions.SSL, (Serializable)((Object)"false")))) {
            protocol = protocol + "s";
        }
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(protocol).append("://").append(hosts).append('/');
        if (!database.isEmpty()) {
            urlBuilder.append(database);
        }
        String user = this.getOptionValueAsString(cfOpt, ConnectionFactoryOptions.USER, (Serializable)((Object)""));
        String password = this.getOptionValueAsString(cfOpt, ConnectionFactoryOptions.PASSWORD, (Serializable)((Object)""));
        urlBuilder.append("?user=").append(ClickHouseUtils.encode(user)).append("&password=").append(ClickHouseUtils.encode(password));
        for (Option<?> option : connQueryParams) {
            Object value = cfOpt.getValue(option);
            if (value == null) continue;
            urlBuilder.append('&').append(option.name()).append('=').append(ClickHouseUtils.encode(cfOpt.getValue(option).toString()));
        }
        ClickHouseNodes nodes = ClickHouseNodes.of(urlBuilder.toString());
        return new ClickHouseConnectionFactory(nodes);
    }

    public boolean supports(ConnectionFactoryOptions connectionFactoryOptions) {
        String driverIdentifier = Objects.toString(connectionFactoryOptions.getValue(ConnectionFactoryOptions.DRIVER));
        return "ch".equalsIgnoreCase(driverIdentifier) || CLICKHOUSE_DRIVER.equalsIgnoreCase(driverIdentifier);
    }

    public String getDriver() {
        return CLICKHOUSE_DRIVER;
    }

    static {
        LinkedHashSet<Option> allOptions = new LinkedHashSet<Option>();
        for (ClickHouseClientOption option : ClickHouseClientOption.values()) {
            allOptions.add(Option.valueOf((String)option.getKey()));
        }
        try {
            for (ClickHouseClient client : ServiceLoader.load(ClickHouseClient.class, ClickHouseConnectionFactoryProvider.class.getClassLoader())) {
                for (ClickHouseOption option : client.getOptionClass().getEnumConstants()) {
                    allOptions.add(Option.valueOf((String)option.getKey()));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        connQueryParams = Collections.unmodifiableList(new ArrayList(allOptions));
    }
}

