/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.internal;

import com.clickhouse.client.api.internal.ClickHouseLZ4InputStream;
import com.clickhouse.client.api.internal.ClickHouseLZ4OutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import net.jpountz.lz4.LZ4Factory;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorInputStream;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorOutputStream;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;

class LZ4Entity
implements HttpEntity {
    private HttpEntity httpEntity;
    private final boolean useHttpCompression;
    private final int bufferSize;
    private final boolean isResponse;
    private boolean serverCompression;
    private boolean clientCompression;

    LZ4Entity(HttpEntity httpEntity, boolean useHttpCompression, boolean serverCompression, boolean clientCompression, int bufferSize, boolean isResponse) {
        this.httpEntity = httpEntity;
        this.useHttpCompression = useHttpCompression;
        this.bufferSize = bufferSize;
        this.serverCompression = serverCompression;
        this.clientCompression = clientCompression;
        this.isResponse = isResponse;
    }

    public boolean isRepeatable() {
        return this.httpEntity.isRepeatable();
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        if (!this.isResponse && this.serverCompression) {
            throw new UnsupportedOperationException("Unsupported: getting compressed content of request");
        }
        if (this.serverCompression) {
            if (this.useHttpCompression) {
                InputStream content = this.httpEntity.getContent();
                try {
                    return new FramedLZ4CompressorInputStream(content);
                }
                catch (IOException e) {
                    return content;
                }
            }
            return new ClickHouseLZ4InputStream(this.httpEntity.getContent(), LZ4Factory.fastestInstance().fastDecompressor(), this.bufferSize);
        }
        return this.httpEntity.getContent();
    }

    public void writeTo(OutputStream outStream) throws IOException {
        if (this.isResponse && this.serverCompression) {
            throw new UnsupportedOperationException("Unsupported: writing compressed response to elsewhere");
        }
        if (this.clientCompression) {
            if (this.useHttpCompression) {
                this.httpEntity.writeTo((OutputStream)new FramedLZ4CompressorOutputStream(outStream));
            } else {
                this.httpEntity.writeTo((OutputStream)new ClickHouseLZ4OutputStream(outStream, LZ4Factory.fastestInstance().fastCompressor(), this.bufferSize));
            }
        } else {
            this.httpEntity.writeTo(outStream);
        }
    }

    public boolean isStreaming() {
        return this.httpEntity.isStreaming();
    }

    public Supplier<List<? extends Header>> getTrailers() {
        return this.httpEntity.getTrailers();
    }

    public void close() throws IOException {
        this.httpEntity.close();
    }

    public long getContentLength() {
        return this.httpEntity.getContentLength();
    }

    public String getContentType() {
        return this.httpEntity.getContentType();
    }

    public String getContentEncoding() {
        return this.httpEntity.getContentEncoding();
    }

    public boolean isChunked() {
        return this.httpEntity.isChunked();
    }

    public Set<String> getTrailerNames() {
        return this.httpEntity.getTrailerNames();
    }
}

