/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.query;

import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.api.ClientException;
import com.clickhouse.client.api.internal.ClientStatisticsHolder;
import com.clickhouse.client.api.internal.ClientV1AdaptorHelper;
import com.clickhouse.client.api.metrics.OperationMetrics;
import com.clickhouse.client.api.metrics.ServerMetrics;
import com.clickhouse.client.api.query.QuerySettings;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.data.ClickHouseFormat;
import java.io.InputStream;
import java.util.TimeZone;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;

public class QueryResponse
implements AutoCloseable {
    private final ClickHouseResponse clickHouseResponse;
    private final ClickHouseFormat format;
    private QuerySettings settings;
    private OperationMetrics operationMetrics;
    private ClassicHttpResponse httpResponse;

    @Deprecated
    public QueryResponse(ClickHouseResponse clickHouseResponse, ClickHouseFormat format, ClientStatisticsHolder clientStatisticsHolder, QuerySettings settings) {
        this.clickHouseResponse = clickHouseResponse;
        this.format = format;
        this.operationMetrics = new OperationMetrics(clientStatisticsHolder);
        this.operationMetrics.operationComplete();
        this.operationMetrics.setQueryId(clickHouseResponse.getSummary().getQueryId());
        this.settings = settings;
        ClientV1AdaptorHelper.setServerStats(clickHouseResponse.getSummary().getProgress(), this.operationMetrics);
        this.settings.setOption(ClickHouseClientOption.SERVER_TIME_ZONE.getKey(), clickHouseResponse.getTimeZone());
    }

    public QueryResponse(ClassicHttpResponse response, ClickHouseFormat format, QuerySettings settings, OperationMetrics operationMetrics) {
        this.clickHouseResponse = null;
        this.httpResponse = response;
        this.format = format;
        this.operationMetrics = operationMetrics;
        this.settings = settings;
        Header tzHeader = response.getFirstHeader("X-ClickHouse-Timezone");
        if (tzHeader != null) {
            try {
                this.settings.setOption(ClickHouseClientOption.SERVER_TIME_ZONE.getKey(), TimeZone.getTimeZone(tzHeader.getValue()));
            }
            catch (Exception e) {
                throw new ClientException("Failed to parse server timezone", e);
            }
        }
    }

    public InputStream getInputStream() {
        if (this.clickHouseResponse != null) {
            try {
                return this.clickHouseResponse.getInputStream();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return this.httpResponse.getEntity().getContent();
        }
        catch (Exception e) {
            throw new ClientException("Failed to construct input stream", e);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.clickHouseResponse != null) {
            try {
                this.clickHouseResponse.close();
            }
            catch (Exception e) {
                throw new ClientException("Failed to close response", e);
            }
        }
        if (this.httpResponse != null) {
            try {
                this.httpResponse.close();
            }
            catch (Exception e) {
                throw new ClientException("Failed to close response", e);
            }
        }
    }

    public ClickHouseFormat getFormat() {
        return this.format;
    }

    public OperationMetrics getMetrics() {
        return this.operationMetrics;
    }

    public long getReadRows() {
        return this.operationMetrics.getMetric(ServerMetrics.NUM_ROWS_READ).getLong();
    }

    public long getReadBytes() {
        return this.operationMetrics.getMetric(ServerMetrics.NUM_BYTES_READ).getLong();
    }

    public long getWrittenRows() {
        return this.operationMetrics.getMetric(ServerMetrics.NUM_ROWS_WRITTEN).getLong();
    }

    public long getWrittenBytes() {
        return this.operationMetrics.getMetric(ServerMetrics.NUM_BYTES_WRITTEN).getLong();
    }

    public long getServerTime() {
        return this.operationMetrics.getMetric(ServerMetrics.ELAPSED_TIME).getLong();
    }

    public long getResultRows() {
        return this.operationMetrics.getMetric(ServerMetrics.RESULT_ROWS).getLong();
    }

    public String getQueryId() {
        return this.operationMetrics.getQueryId();
    }

    public TimeZone getTimeZone() {
        return this.settings.getOption(ClickHouseClientOption.SERVER_TIME_ZONE.getKey()) == null ? null : (TimeZone)this.settings.getOption(ClickHouseClientOption.SERVER_TIME_ZONE.getKey());
    }

    public QuerySettings getSettings() {
        return this.settings;
    }
}

