/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.query;

import com.clickhouse.client.api.ClientConfigProperties;
import com.clickhouse.client.api.internal.ValidationUtils;
import com.clickhouse.data.ClickHouseFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class QuerySettings {
    public static final int MINIMAL_READ_BUFFER_SIZE = 8192;
    private Map<String, Object> rawSettings = new HashMap<String, Object>();
    private String logComment = null;

    public QuerySettings setOption(String option, Object value) {
        this.rawSettings.put(option, value);
        if (option.equals(ClientConfigProperties.PRODUCT_NAME.getKey())) {
            this.rawSettings.put(ClientConfigProperties.CLIENT_NAME.getKey(), value);
        }
        return this;
    }

    public Object getOption(String option) {
        return this.rawSettings.get(option);
    }

    public Map<String, Object> getAllSettings() {
        return this.rawSettings;
    }

    public QuerySettings setQueryId(String queryId) {
        this.rawSettings.put("query_id", queryId);
        return this;
    }

    public String getQueryId() {
        return (String)this.rawSettings.get("query_id");
    }

    public QuerySettings setReadBufferSize(Integer size) {
        ValidationUtils.checkNotNull(size, "read_buffer_size");
        ValidationUtils.checkRange(size, 8192, Integer.MAX_VALUE, "read_buffer_size");
        this.rawSettings.put("read_buffer_size", size);
        return this;
    }

    public Integer getReadBufferSize() {
        return (Integer)this.rawSettings.get("read_buffer_size");
    }

    public QuerySettings setFormat(ClickHouseFormat format) {
        this.rawSettings.put("format", format);
        return this;
    }

    public ClickHouseFormat getFormat() {
        return (ClickHouseFormat)this.rawSettings.get("format");
    }

    public QuerySettings setMaxExecutionTime(Integer maxExecutionTime) {
        this.rawSettings.put("max_execution_time", maxExecutionTime);
        return this;
    }

    public Integer getMaxExecutionTime() {
        return (Integer)this.rawSettings.get("max_execution_time");
    }

    public QuerySettings setDatabase(String database) {
        ValidationUtils.checkNonBlank(database, "database");
        this.rawSettings.put("database", database);
        return this;
    }

    public String getDatabase() {
        return (String)this.rawSettings.get("database");
    }

    public QuerySettings waitEndOfQuery(Boolean waitEndOfQuery) {
        this.serverSetting("wait_end_of_query", waitEndOfQuery != false ? "1" : "0");
        return this;
    }

    public QuerySettings setUseServerTimeZone(Boolean useServerTimeZone) {
        if (this.rawSettings.containsKey(ClientConfigProperties.USE_TIMEZONE.getKey())) {
            throw new ValidationUtils.SettingsValidationException(ClientConfigProperties.USE_SERVER_TIMEZONE.getKey(), "Cannot set both use_time_zone and use_server_time_zone");
        }
        this.rawSettings.put(ClientConfigProperties.USE_SERVER_TIMEZONE.getKey(), useServerTimeZone);
        return this;
    }

    public Boolean getUseServerTimeZone() {
        return (Boolean)this.rawSettings.get(ClientConfigProperties.USE_SERVER_TIMEZONE.getKey());
    }

    public QuerySettings setUseTimeZone(String timeZone) {
        if (this.rawSettings.containsKey(ClientConfigProperties.USE_SERVER_TIMEZONE.getKey())) {
            throw new ValidationUtils.SettingsValidationException(ClientConfigProperties.USE_TIMEZONE.getKey(), "Cannot set both use_time_zone and use_server_time_zone");
        }
        this.rawSettings.put(ClientConfigProperties.USE_TIMEZONE.getKey(), TimeZone.getTimeZone(timeZone));
        return this;
    }

    public TimeZone getServerTimeZone() {
        return (TimeZone)this.rawSettings.get(ClientConfigProperties.SERVER_TIMEZONE.getKey());
    }

    public QuerySettings httpHeader(String key, String value) {
        this.rawSettings.put("http_header_" + key, value);
        return this;
    }

    public QuerySettings httpHeader(String key, Collection<String> values) {
        this.rawSettings.put("http_header_" + key, ClientConfigProperties.commaSeparated(values));
        return this;
    }

    public QuerySettings httpHeaders(Map<String, String> headers) {
        headers.forEach(this::httpHeader);
        return this;
    }

    public QuerySettings serverSetting(String name, String value) {
        this.rawSettings.put(ClientConfigProperties.serverSetting(name), value);
        return this;
    }

    public QuerySettings serverSetting(String name, Collection<String> values) {
        this.rawSettings.put(ClientConfigProperties.serverSetting(name), ClientConfigProperties.commaSeparated(values));
        return this;
    }

    public QuerySettings setDBRoles(Collection<String> dbRoles) {
        this.rawSettings.put(ClientConfigProperties.SESSION_DB_ROLES.getKey(), dbRoles);
        return this;
    }

    public Collection<String> getDBRoles() {
        return (Collection)this.rawSettings.get(ClientConfigProperties.SESSION_DB_ROLES.getKey());
    }

    public QuerySettings logComment(String logComment) {
        this.logComment = logComment;
        if (logComment != null && !logComment.isEmpty()) {
            this.rawSettings.put(ClientConfigProperties.SETTING_LOG_COMMENT.getKey(), logComment);
        }
        return this;
    }

    public String getLogComment() {
        return this.logComment;
    }

    public static QuerySettings merge(QuerySettings source, QuerySettings override) {
        QuerySettings merged = new QuerySettings();
        if (source != null) {
            merged.rawSettings.putAll(source.rawSettings);
        }
        if (override != null && override != source) {
            merged.rawSettings.putAll(override.rawSettings);
        }
        return merged;
    }
}

