/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.internal;

import com.clickhouse.client.api.metadata.TableSchema;
import com.clickhouse.data.ClickHouseColumn;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Properties;

public class TableSchemaParser {
    public static TableSchema readTSKV(InputStream content, String table, String sqlQuery, String database) {
        TableSchema tableSchema;
        Properties p = new Properties();
        BufferedReader r = new BufferedReader(new InputStreamReader(content));
        try {
            String line;
            ArrayList<ClickHouseColumn> columns = new ArrayList<ClickHouseColumn>();
            while ((line = r.readLine()) != null) {
                p.clear();
                if (line.trim().isEmpty()) continue;
                p.load(new StringReader(line.replaceAll("\t", "\n")));
                ClickHouseColumn column = ClickHouseColumn.of((String)p.getProperty("name"), (String)p.getProperty("type"));
                String defaultType = p.getProperty("default_type");
                column.setHasDefault(defaultType != null && !defaultType.isEmpty());
                columns.add(column);
            }
            tableSchema = new TableSchema(table, sqlQuery, database, columns);
        }
        catch (Throwable throwable) {
            try {
                try {
                    r.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to parse table schema", e);
            }
        }
        r.close();
        return tableSchema;
    }
}

