/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.trace;

import io.opencensus.implcore.internal.EventQueue;
import io.opencensus.implcore.trace.RecordEventsSpanImpl;
import io.opencensus.implcore.trace.export.InProcessRunningSpanStore;
import io.opencensus.implcore.trace.export.SampledSpanStoreImpl;
import io.opencensus.implcore.trace.export.SpanExporterImpl;
import io.opencensus.trace.Span;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class StartEndHandlerImpl
implements RecordEventsSpanImpl.StartEndHandler {
    private final SpanExporterImpl spanExporter;
    private final InProcessRunningSpanStore inProcessRunningSpanStore;
    private final SampledSpanStoreImpl sampledSpanStore;
    private final EventQueue eventQueue;

    public StartEndHandlerImpl(SpanExporterImpl spanExporter, InProcessRunningSpanStore inProcessRunningSpanStore, SampledSpanStoreImpl sampledSpanStore, EventQueue eventQueue) {
        this.spanExporter = spanExporter;
        this.inProcessRunningSpanStore = inProcessRunningSpanStore;
        this.sampledSpanStore = sampledSpanStore;
        this.eventQueue = eventQueue;
    }

    @Override
    public void onStart(RecordEventsSpanImpl span) {
        if (span.getOptions().contains((Object)Span.Options.RECORD_EVENTS) && this.inProcessRunningSpanStore.getEnabled()) {
            this.eventQueue.enqueue(new SpanStartEvent(span, this.inProcessRunningSpanStore));
        }
    }

    @Override
    public void onEnd(RecordEventsSpanImpl span) {
        if (span.getOptions().contains((Object)Span.Options.RECORD_EVENTS) && (this.inProcessRunningSpanStore.getEnabled() || this.sampledSpanStore.getEnabled()) || span.getContext().getTraceOptions().isSampled()) {
            this.eventQueue.enqueue(new SpanEndEvent(span, this.spanExporter, this.inProcessRunningSpanStore, this.sampledSpanStore));
        }
    }

    private static final class SpanEndEvent
    implements EventQueue.Entry {
        private final RecordEventsSpanImpl span;
        private final InProcessRunningSpanStore inProcessRunningSpanStore;
        private final SpanExporterImpl spanExporter;
        @Nullable
        private final SampledSpanStoreImpl sampledSpanStore;

        SpanEndEvent(RecordEventsSpanImpl span, SpanExporterImpl spanExporter, InProcessRunningSpanStore inProcessRunningSpanStore, @Nullable SampledSpanStoreImpl sampledSpanStore) {
            this.span = span;
            this.inProcessRunningSpanStore = inProcessRunningSpanStore;
            this.spanExporter = spanExporter;
            this.sampledSpanStore = sampledSpanStore;
        }

        @Override
        public void process() {
            if (this.span.getContext().getTraceOptions().isSampled()) {
                this.spanExporter.addSpan(this.span);
            }
            this.inProcessRunningSpanStore.onEnd(this.span);
            if (this.sampledSpanStore != null) {
                this.sampledSpanStore.considerForSampling(this.span);
            }
        }
    }

    private static final class SpanStartEvent
    implements EventQueue.Entry {
        private final RecordEventsSpanImpl span;
        private final InProcessRunningSpanStore inProcessRunningSpanStore;

        SpanStartEvent(RecordEventsSpanImpl span, InProcessRunningSpanStore inProcessRunningSpanStore) {
            this.span = span;
            this.inProcessRunningSpanStore = inProcessRunningSpanStore;
        }

        @Override
        public void process() {
            this.inProcessRunningSpanStore.onStart(this.span);
        }
    }
}

