/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.data_formats;

import com.clickhouse.client.api.data_formats.internal.SerializerUtils;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.data.format.BinaryStreamUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class RowBinaryFormatSerializer {
    private OutputStream out;

    public RowBinaryFormatSerializer(OutputStream out) {
        this.out = out;
    }

    public void writeNull() throws IOException {
        SerializerUtils.writeNull(this.out);
    }

    public void writeNotNull() throws IOException {
        SerializerUtils.writeNonNull(this.out);
    }

    public void writeDefault() throws IOException {
        SerializerUtils.writeBoolean(this.out, true);
    }

    public void writeInt8(byte value) throws IOException {
        BinaryStreamUtils.writeInt8(this.out, value);
    }

    public void writeUInt8(short value) throws IOException {
        BinaryStreamUtils.writeUnsignedInt8(this.out, value);
    }

    public void writeInt16(short value) throws IOException {
        BinaryStreamUtils.writeInt16(this.out, value);
    }

    public void writeUInt16(int value) throws IOException {
        BinaryStreamUtils.writeUnsignedInt16(this.out, value);
    }

    public void writeInt32(int value) throws IOException {
        BinaryStreamUtils.writeInt32(this.out, value);
    }

    public void writeUInt32(long value) throws IOException {
        BinaryStreamUtils.writeUnsignedInt32(this.out, value);
    }

    public void writeInt64(long value) throws IOException {
        BinaryStreamUtils.writeInt64(this.out, value);
    }

    public void writeUInt64(BigInteger value) throws IOException {
        BinaryStreamUtils.writeUnsignedInt64(this.out, value);
    }

    public void writeInt128(BigInteger value) throws IOException {
        BinaryStreamUtils.writeInt128(this.out, value);
    }

    public void writeUInt128(BigInteger value) throws IOException {
        BinaryStreamUtils.writeUnsignedInt128(this.out, value);
    }

    public void writeInt256(BigInteger value) throws IOException {
        BinaryStreamUtils.writeInt256(this.out, value);
    }

    public void writeUInt256(BigInteger value) throws IOException {
        BinaryStreamUtils.writeUnsignedInt128(this.out, value);
    }

    public void writeBool(boolean value) throws IOException {
        BinaryStreamUtils.writeBoolean(this.out, value);
    }

    public void writeFloat32(float value) throws IOException {
        BinaryStreamUtils.writeFloat32(this.out, value);
    }

    public void writeFloat64(double value) throws IOException {
        BinaryStreamUtils.writeFloat64(this.out, value);
    }

    public void writeDecimal(BigDecimal value, int precision, int scale) throws IOException {
        BinaryStreamUtils.writeDecimal(this.out, value, precision, scale);
    }

    public void writeDecimal32(BigDecimal value, int scale) throws IOException {
        BinaryStreamUtils.writeDecimal32(this.out, value, scale);
    }

    public void writeDecimal64(BigDecimal value, int scale) throws IOException {
        BinaryStreamUtils.writeDecimal64(this.out, value, scale);
    }

    public void writeDecimal128(BigDecimal value, int scale) throws IOException {
        BinaryStreamUtils.writeDecimal128(this.out, value, scale);
    }

    public void writeDecimal256(BigDecimal value, int scale) throws IOException {
        BinaryStreamUtils.writeDecimal256(this.out, value, scale);
    }

    public void writeString(String value) throws IOException {
        BinaryStreamUtils.writeString(this.out, value);
    }

    public void writeFixedString(String value, int len) throws IOException {
        BinaryStreamUtils.writeFixedString(this.out, value, len);
    }

    public void writeDate(ZonedDateTime value) throws IOException {
        SerializerUtils.writeDate(this.out, value, ZoneId.of("UTC"));
    }

    public void writeDate32(ZonedDateTime value, ZoneId targetTz) throws IOException {
        SerializerUtils.writeDate32(this.out, value, targetTz);
    }

    public void writeDateTime(ZonedDateTime value, ZoneId targetTz) throws IOException {
        SerializerUtils.writeDateTime(this.out, value, targetTz);
    }

    public void writeDateTime64(ZonedDateTime value, int scale, ZoneId targetTz) throws IOException {
        SerializerUtils.writeDateTime64(this.out, value, scale, targetTz);
    }

    public void writeEnum8(byte value) throws IOException {
        BinaryStreamUtils.writeEnum8(this.out, value);
    }

    public void writeEnum16(short value) throws IOException {
        BinaryStreamUtils.writeEnum16(this.out, value);
    }

    public void writeUUID(long leastSignificantBits, long mostSignificantBits) throws IOException {
        BinaryStreamUtils.writeInt64(this.out, mostSignificantBits);
        BinaryStreamUtils.writeInt64(this.out, leastSignificantBits);
    }

    public void writeIPV4Address(Inet4Address value) throws IOException {
        BinaryStreamUtils.writeInet4Address(this.out, value);
    }

    public void writeIPV6Address(Inet6Address value) throws IOException {
        BinaryStreamUtils.writeInet6Address(this.out, value);
    }

    public static boolean writeValuePreamble(OutputStream out, boolean defaultsSupport, ClickHouseColumn column, Object value) throws IOException {
        return RowBinaryFormatSerializer.writeValuePreamble(out, defaultsSupport, value, column.isNullable(), column.getDataType(), column.hasDefault(), column.getColumnName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean writeValuePreamble(OutputStream out, boolean defaultsSupport, Object value, boolean isNullable, ClickHouseDataType dataType, boolean hasDefault, String column) throws IOException {
        if (defaultsSupport) {
            if (value != null) {
                SerializerUtils.writeNonNull(out);
                if (!isNullable) return true;
                SerializerUtils.writeNonNull(out);
                return true;
            } else {
                if (hasDefault) {
                    SerializerUtils.writeNull(out);
                    return false;
                }
                if (isNullable) {
                    SerializerUtils.writeNonNull(out);
                    SerializerUtils.writeNull(out);
                    return false;
                }
                if (dataType != ClickHouseDataType.Array) throw new IllegalArgumentException(String.format("An attempt to write null into not nullable column '%s'", column));
                SerializerUtils.writeNonNull(out);
            }
            return true;
        } else if (isNullable) {
            if (value == null) {
                SerializerUtils.writeNull(out);
                return false;
            }
            SerializerUtils.writeNonNull(out);
            return true;
        } else {
            if (value != null) return true;
            if (dataType != ClickHouseDataType.Array) throw new IllegalArgumentException(String.format("An attempt to write null into not nullable column '%s'", column));
            SerializerUtils.writeNonNull(out);
        }
        return true;
    }

    public static void writeSize(OutputStream out, long size) throws IOException {
        SerializerUtils.writeVarInt(out, size);
    }
}

