/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.jdbc.Driver;
import com.clickhouse.jdbc.JdbcV2Wrapper;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ConnectionBuilder;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.ShardingKeyBuilder;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class DataSourceImpl
implements DataSource,
JdbcV2Wrapper {
    private static final Logger log = Logger.getLogger(DataSourceImpl.class.getName());
    private String url;
    private Properties info;
    private final Driver driver;
    private PrintWriter logWriter;

    public void setUrl(String url) {
        this.url = url;
    }

    private Properties getProperties() {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)this.info);
        return copy;
    }

    public void setProperties(Properties info) {
        this.info = info;
    }

    public DataSourceImpl() {
        this(null, new Properties());
    }

    public DataSourceImpl(String url, Properties info) {
        this.url = url;
        this.info = info;
        this.driver = new Driver(this);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.driver.connect(this.url, this.info);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Properties info = this.getProperties();
        info.setProperty("user", username);
        info.setProperty("password", password);
        return this.driver.connect(this.url, info);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported", "0A000");
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported", "0A000");
    }

    @Override
    public ConnectionBuilder createConnectionBuilder() throws SQLException {
        return DataSource.super.createConnectionBuilder();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Method not supported", "0A000");
    }

    @Override
    public ShardingKeyBuilder createShardingKeyBuilder() throws SQLException {
        return DataSource.super.createShardingKeyBuilder();
    }
}

