/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.api.metadata.TableSchema;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.jdbc.ResultSetImpl;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;

public class MetadataResultSet
extends ResultSetImpl {
    private final Map<String, UnaryOperator<String>> columnTransformers = new HashMap<String, UnaryOperator<String>>();
    private final String[] cachedColumnLabels;
    private final OverridingSchemaAdaptor overridingSchemaAdaptor;

    public MetadataResultSet(ResultSetImpl resultSet) throws SQLException {
        super(resultSet);
        this.overridingSchemaAdaptor = new OverridingSchemaAdaptor(resultSet.getSchema());
        ResultSetMetaData metaData = this.getMetaData();
        int count = metaData.getColumnCount();
        this.cachedColumnLabels = new String[count];
        for (int i = 1; i <= count; ++i) {
            this.cachedColumnLabels[i - 1] = metaData.getColumnLabel(i).toUpperCase();
        }
    }

    public MetadataResultSet transform(String columnLabel, ClickHouseColumn column, UnaryOperator<String> transformer) {
        if (columnLabel != null && transformer != null) {
            this.columnTransformers.put(columnLabel.toUpperCase(), transformer);
        }
        this.overridingSchemaAdaptor.setOverriddenColumn(this.overridingSchemaAdaptor.nameToIndex(columnLabel), column);
        return this;
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        String value = super.getString(columnLabel);
        UnaryOperator<String> transformer = this.columnTransformers.get(columnLabel.toUpperCase());
        if (transformer != null && value != null) {
            return (String)transformer.apply(value);
        }
        return value;
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        String stringValue = this.getString(columnLabel);
        if (stringValue == null || stringValue.trim().isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e) {
            throw new SQLException("Value for column '" + columnLabel + "' is not a valid integer: " + stringValue, e);
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.cachedColumnLabels.length) {
            throw new SQLException("Invalid column index: " + columnIndex);
        }
        return this.getString(this.cachedColumnLabels[columnIndex - 1]);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.cachedColumnLabels.length) {
            throw new SQLException("Invalid column index: " + columnIndex);
        }
        return this.getInt(this.cachedColumnLabels[columnIndex - 1]);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return (byte)this.getInt(columnIndex);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return (short)this.getInt(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.getInt(columnIndex);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return (byte)this.getInt(columnLabel);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return (short)this.getInt(columnLabel);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getInt(columnLabel);
    }

    @Override
    public TableSchema getSchema() {
        return this.overridingSchemaAdaptor;
    }

    private static class OverridingSchemaAdaptor
    extends TableSchema {
        private final TableSchema originalSchema;
        private final List<ClickHouseColumn> overriddenColumns;

        public OverridingSchemaAdaptor(TableSchema originalSchema) {
            super(Collections.emptyList());
            this.originalSchema = originalSchema;
            this.overriddenColumns = new ArrayList<ClickHouseColumn>(originalSchema.getColumns());
        }

        public void setOverriddenColumn(int index, ClickHouseColumn column) {
            if (index < 0 || index >= this.overriddenColumns.size()) {
                throw new IndexOutOfBoundsException("Index " + index + " is out of bounds for overridden columns.");
            }
            this.overriddenColumns.set(index, column);
        }

        @Override
        public List<ClickHouseColumn> getColumns() {
            return this.overriddenColumns;
        }

        @Override
        public String getDatabaseName() {
            return this.originalSchema.getDatabaseName();
        }

        @Override
        public String getTableName() {
            return this.originalSchema.getTableName();
        }

        @Override
        public boolean hasDefaults() {
            return this.originalSchema.hasDefaults();
        }

        @Override
        public String getQuery() {
            return this.originalSchema.getQuery();
        }

        @Override
        public ClickHouseColumn getColumnByName(String name) {
            return this.overriddenColumns.get(this.originalSchema.nameToIndex(name));
        }

        @Override
        public ClickHouseColumn getColumnByIndex(int colIndex) {
            return this.overriddenColumns.get(colIndex - 1);
        }

        @Override
        public String indexToName(int index) {
            return this.originalSchema.indexToName(index);
        }

        @Override
        public String columnIndexToName(int index) {
            return this.originalSchema.columnIndexToName(index);
        }

        @Override
        public int nameToColumnIndex(String name) {
            return this.originalSchema.nameToColumnIndex(name);
        }

        @Override
        public int nameToIndex(String name) {
            return this.originalSchema.nameToIndex(name);
        }

        @Override
        public String toString() {
            return this.originalSchema.toString();
        }
    }
}

