/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.cache;

import com.clickhouse.data.ClickHouseCache;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@Deprecated
public class JdkLruCache<K, V>
implements ClickHouseCache<K, V> {
    private final Map<K, V> cache;
    private final Function<K, V> loadFunc;

    public static <K, V> ClickHouseCache<K, V> create(int capacity, Function<K, V> loadFunc) {
        return new JdkLruCache(new LruCacheMap(capacity), loadFunc);
    }

    protected JdkLruCache(Map<K, V> cache, Function<K, V> loadFunc) {
        if (cache == null || loadFunc == null) {
            throw new IllegalArgumentException("Non-null cache and load function are required");
        }
        this.cache = Collections.synchronizedMap(cache);
        this.loadFunc = loadFunc;
    }

    @Override
    public V get(K key) {
        return this.cache.computeIfAbsent(key, this.loadFunc);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        return Objects.requireNonNull(clazz, "Non-null class is required").cast(this.cache);
    }

    static class LruCacheMap<K, V>
    extends LinkedHashMap<K, V> {
        private final int capacity;

        protected LruCacheMap(int capacity) {
            super(capacity, 0.75f, true);
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.capacity;
        }
    }
}

