/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.http;

import com.clickhouse.client.AbstractClient;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseResponseSummary;
import com.clickhouse.client.ClickHouseStreamResponse;
import com.clickhouse.client.ClickHouseTransaction;
import com.clickhouse.client.http.ClickHouseHttpConnection;
import com.clickhouse.client.http.ClickHouseHttpConnectionFactory;
import com.clickhouse.client.http.ClickHouseHttpResponse;
import com.clickhouse.client.http.config.ClickHouseHttpOption;
import com.clickhouse.config.ClickHouseOption;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;

@Deprecated
public class ClickHouseHttpClient
extends AbstractClient<ClickHouseHttpConnection> {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseHttpClient.class);
    static final List<ClickHouseProtocol> SUPPORTED = Collections.singletonList(ClickHouseProtocol.HTTP);
    public static HostNameAndAddress LOCAL_HOST = null;
    protected ConcurrentSkipListSet<String> roles = new ConcurrentSkipListSet();

    private static HostNameAndAddress getLocalHost() {
        HostNameAndAddress hostNameAndAddress;
        block4: {
            hostNameAndAddress = new HostNameAndAddress();
            try {
                Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                for (NetworkInterface ni : Collections.list(networkInterfaces)) {
                    Enumeration<InetAddress> inetAddresses = ni.getInetAddresses();
                    for (InetAddress ia : Collections.list(inetAddresses)) {
                        if (ia.isLoopbackAddress() || ia.isLinkLocalAddress()) continue;
                        hostNameAndAddress.address = ia.getHostAddress();
                        hostNameAndAddress.hostName = ia.getCanonicalHostName();
                        break block4;
                    }
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        return hostNameAndAddress;
    }

    public static String getReferer(ClickHouseConfig config) {
        String referer = null;
        if (!ClickHouseChecker.isNullOrEmpty(config.getStrOption((ClickHouseOption)ClickHouseHttpOption.SEND_HTTP_CLIENT_ID)) && ClickHouseChecker.isNullOrEmpty(ClickHouseOption.toKeyValuePairs(config.getStrOption((ClickHouseOption)ClickHouseHttpOption.CUSTOM_HEADERS)).get("referer"))) {
            referer = config.getStrOption((ClickHouseOption)ClickHouseHttpOption.SEND_HTTP_CLIENT_ID).equals("HOST_NAME") ? ClickHouseHttpClient.LOCAL_HOST.hostName : ClickHouseHttpClient.LOCAL_HOST.address;
        }
        return referer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClickHouseHttpClient() {
        ClickHouseHttpClient clickHouseHttpClient = this;
        synchronized (clickHouseHttpClient) {
            if (LOCAL_HOST == null) {
                LOCAL_HOST = ClickHouseHttpClient.getLocalHost();
            }
        }
    }

    protected boolean checkConnection(ClickHouseHttpConnection connection, ClickHouseNode requestServer, ClickHouseNode currentServer, ClickHouseRequest<?> request) {
        return connection != null && connection.isReusable() && requestServer.isSameEndpoint(currentServer);
    }

    protected boolean checkHealth(ClickHouseNode server, int timeout) {
        return ((ClickHouseHttpConnection)this.getConnection(this.read(server))).ping(timeout);
    }

    protected Collection<ClickHouseProtocol> getSupportedProtocols() {
        return SUPPORTED;
    }

    protected ClickHouseHttpConnection newConnection(ClickHouseHttpConnection connection, ClickHouseNode server, ClickHouseRequest<?> request) {
        if (connection != null && connection.isReusable()) {
            this.closeConnection(connection, false);
        }
        try {
            return ClickHouseHttpConnectionFactory.createConnection(server, request, this.getExecutor(), this.buildAdditionalReqParams(request));
        }
        catch (IOException e) {
            throw new CompletionException(e);
        }
    }

    protected void closeConnection(ClickHouseHttpConnection connection, boolean force) {
        try {
            connection.close();
        }
        catch (Exception e) {
            log.warn((Object)"Failed to close http connection due to: %s", e.getMessage());
        }
    }

    protected String buildQueryParams(Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            builder.append(ClickHouseHttpConnection.urlEncode(entry.getKey(), StandardCharsets.UTF_8)).append('=').append(ClickHouseHttpConnection.urlEncode(entry.getValue(), StandardCharsets.UTF_8)).append('&');
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    private Map<String, Serializable> buildAdditionalReqParams(ClickHouseRequest<?> sealedRequest) {
        ClickHouseConfig config = sealedRequest.getConfig();
        if (config.getBoolOption((ClickHouseOption)ClickHouseHttpOption.REMEMBER_LAST_SET_ROLES) && !sealedRequest.hasSetting("_set_roles_stmt") && !this.roles.isEmpty()) {
            return Collections.singletonMap("_roles", this.roles);
        }
        return Collections.emptyMap();
    }

    protected ClickHouseResponse send(ClickHouseRequest<?> sealedRequest) throws ClickHouseException, IOException {
        ClickHouseHttpResponse httpResponse;
        ClickHouseHttpConnection conn = (ClickHouseHttpConnection)this.getConnection(sealedRequest);
        List stmts = sealedRequest.getStatements(false);
        int size = stmts.size();
        if (size == 0) {
            throw new IllegalArgumentException("At least one SQL statement is required for execution");
        }
        if (size > 1) {
            throw new IllegalArgumentException("Expect one SQL statement to execute but we got " + size);
        }
        String sql = (String)stmts.get(0);
        log.debug((Object)"Query: %s", sql);
        ClickHouseConfig config = sealedRequest.getConfig();
        ClickHouseTransaction tx = sealedRequest.getTransaction();
        Runnable postAction = tx != null && tx.isImplicit() ? () -> {
            try {
                tx.commit();
            }
            catch (ClickHouseException e) {
                throw new UncheckedIOException(new IOException(e.getMessage()));
            }
        } : null;
        ClickHouseNode server = sealedRequest.getServer();
        if (conn.isReusable()) {
            Map<String, Serializable> additionalParams = this.buildAdditionalReqParams(sealedRequest);
            httpResponse = conn.post(config, sql, sealedRequest.getInputStream().orElse(null), sealedRequest.getExternalTables(), sealedRequest.getOutputStream().orElse(null), ClickHouseHttpConnection.buildUrl(server.getBaseUri(), sealedRequest, additionalParams), ClickHouseHttpConnection.createDefaultHeaders(config, server, conn.getUserAgent(), ClickHouseHttpClient.getReferer(config)), postAction);
        } else {
            httpResponse = conn.post(config, sql, sealedRequest.getInputStream().orElse(null), sealedRequest.getExternalTables(), sealedRequest.getOutputStream().orElse(null), null, ClickHouseHttpConnection.createDefaultHeaders(config, server, conn.getUserAgent(), ClickHouseHttpClient.getReferer(config)), postAction);
        }
        if (config.getBoolOption((ClickHouseOption)ClickHouseHttpOption.REMEMBER_LAST_SET_ROLES) && sealedRequest.hasSetting("_set_roles_stmt")) {
            this.rememberRoles((Set)sealedRequest.getSettings().get("_set_roles_stmt"));
        }
        return ClickHouseStreamResponse.of((ClickHouseConfig)httpResponse.getConfig(sealedRequest), (ClickHouseInputStream)httpResponse.getInputStream(), (Map)sealedRequest.getSettings(), null, (ClickHouseResponseSummary)httpResponse.summary, (TimeZone)httpResponse.getTimeZone());
    }

    public final Class<? extends ClickHouseOption> getOptionClass() {
        return ClickHouseHttpOption.class;
    }

    public void rememberRoles(Set<String> requestedRoles) {
        this.roles.clear();
        if (requestedRoles != null) {
            this.roles.addAll(requestedRoles.stream().filter(r -> !"NONE".equalsIgnoreCase((String)r)).collect(Collectors.toList()));
        }
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void clearRoles() {
        this.roles.clear();
    }

    public static class HostNameAndAddress {
        public String hostName;
        public String address;
    }
}

