/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.client.api.ClientConfigProperties;
import com.clickhouse.client.api.data_formats.ClickHouseBinaryFormatReader;
import com.clickhouse.client.api.query.QueryResponse;
import com.clickhouse.client.api.query.QuerySettings;
import com.clickhouse.client.api.sql.SQLUtils;
import com.clickhouse.jdbc.ConnectionImpl;
import com.clickhouse.jdbc.JdbcV2Wrapper;
import com.clickhouse.jdbc.ResultSetImpl;
import com.clickhouse.jdbc.internal.DriverProperties;
import com.clickhouse.jdbc.internal.ExceptionUtils;
import com.clickhouse.jdbc.internal.ParsedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementImpl
implements Statement,
JdbcV2Wrapper {
    private static final Logger LOG = LoggerFactory.getLogger(StatementImpl.class);
    ConnectionImpl connection;
    protected int queryTimeout;
    protected boolean isPoolable = false;
    private volatile boolean closed;
    private final ConcurrentLinkedQueue<ResultSetImpl> resultSets;
    protected ResultSetImpl currentResultSet;
    protected long currentUpdateCount = -1L;
    protected List<String> batch;
    private String lastStatementSql;
    private ParsedStatement parsedStatement;
    protected volatile String lastQueryId;
    private long maxRows;
    private boolean closeOnCompletion;
    private boolean resultSetAutoClose;
    private int maxFieldSize;
    private boolean escapeProcessingEnabled;
    protected QuerySettings localSettings;

    public StatementImpl(ConnectionImpl connection) throws SQLException {
        this.connection = connection;
        this.queryTimeout = 0;
        this.closed = false;
        this.batch = new ArrayList<String>();
        this.maxRows = 0L;
        this.localSettings = QuerySettings.merge((QuerySettings)connection.getDefaultQuerySettings(), (QuerySettings)new QuerySettings());
        this.resultSets = new ConcurrentLinkedQueue();
        this.resultSetAutoClose = connection.getJdbcConfig().isSet(DriverProperties.RESULTSET_AUTO_CLOSE);
        this.escapeProcessingEnabled = true;
    }

    protected void ensureOpen() throws SQLException {
        if (this.closed) {
            throw new SQLException("Statement is closed", "08000");
        }
    }

    private String parseJdbcEscapeSyntax(String sql) {
        LOG.trace("Original SQL: {}", (Object)sql);
        if (this.escapeProcessingEnabled) {
            sql = sql.replaceAll("\\{d '([^']*)'\\}", "toDate('$1')");
            sql = sql.replaceAll("\\{ts '([^']*)'\\}", "timestamp('$1')");
            sql = sql.replaceAll("\\{fn ([^\\}]*)\\}", "$1");
            sql = sql.replaceAll("(?m)^\\s*$\\n?", "");
        }
        LOG.trace("Escaped SQL: {}", (Object)sql);
        return sql;
    }

    protected String getLastStatementSql() {
        return this.lastStatementSql;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.ensureOpen();
        this.currentUpdateCount = -1L;
        this.currentResultSet = this.executeQueryImpl(sql, this.localSettings);
        return this.currentResultSet;
    }

    private void closeCurrentResultSet() {
        if (this.currentResultSet != null) {
            LOG.debug("Previous result set is open [resultSet = " + this.currentResultSet + "]");
            try {
                this.currentResultSet.close();
            }
            catch (Exception e) {
                LOG.error("Failed to close previous result set", (Throwable)e);
            }
            finally {
                this.currentResultSet = null;
            }
        }
    }

    protected ResultSetImpl executeQueryImpl(String sql, QuerySettings settings) throws SQLException {
        QuerySettings mergedSettings;
        this.ensureOpen();
        if (this.resultSetAutoClose) {
            this.closeCurrentResultSet();
        }
        if ((mergedSettings = QuerySettings.merge((QuerySettings)settings, (QuerySettings)new QuerySettings())).getQueryId() == null) {
            String queryId = UUID.randomUUID().toString();
            mergedSettings.setQueryId(queryId);
        }
        this.lastQueryId = mergedSettings.getQueryId();
        LOG.debug("Query ID: {}", (Object)this.lastQueryId);
        QueryResponse response = null;
        try {
            this.lastStatementSql = this.parseJdbcEscapeSyntax(sql);
            LOG.trace("SQL Query: {}", (Object)this.lastStatementSql);
            response = this.queryTimeout == 0 ? (QueryResponse)this.connection.client.query(this.lastStatementSql, mergedSettings).get() : (QueryResponse)this.connection.client.query(this.lastStatementSql, mergedSettings).get(this.queryTimeout, TimeUnit.SECONDS);
            if (response.getFormat().isText()) {
                throw new SQLException("Only RowBinaryWithNameAndTypes is supported for output format. Please check your query.", "HY000");
            }
            ClickHouseBinaryFormatReader reader = this.connection.client.newBinaryFormatReader(response);
            if (reader.getSchema() == null) {
                throw new SQLException("Called method expects empty or filled result set but query has returned none. Consider using `java.sql.Statement.execute(java.lang.String)`", "HY000");
            }
            return new ResultSetImpl(this, response, reader);
        }
        catch (Exception e) {
            if (response != null) {
                try {
                    response.close();
                }
                catch (Exception ex) {
                    LOG.warn("Failed to close response after exception", (Throwable)e);
                }
            }
            this.onResultSetClosed(null);
            throw ExceptionUtils.toSqlState(e);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.ensureOpen();
        return (int)this.executeLargeUpdate(sql);
    }

    protected long executeUpdateImpl(String sql, QuerySettings settings) throws SQLException {
        QuerySettings mergedSettings;
        this.ensureOpen();
        if (this.resultSetAutoClose) {
            this.closeCurrentResultSet();
        }
        if ((mergedSettings = QuerySettings.merge((QuerySettings)this.connection.getDefaultQuerySettings(), (QuerySettings)settings)).getQueryId() == null) {
            String queryId = UUID.randomUUID().toString();
            mergedSettings.setQueryId(queryId);
        }
        this.lastQueryId = mergedSettings.getQueryId();
        this.lastStatementSql = this.parseJdbcEscapeSyntax(sql);
        LOG.trace("SQL Query: {}", (Object)this.lastStatementSql);
        int updateCount = 0;
        try (QueryResponse response = this.queryTimeout == 0 ? (QueryResponse)this.connection.client.query(this.lastStatementSql, mergedSettings).get() : (QueryResponse)this.connection.client.query(this.lastStatementSql, mergedSettings).get(this.queryTimeout, TimeUnit.SECONDS);){
            updateCount = Math.max(0, (int)response.getWrittenRows());
            this.lastQueryId = response.getQueryId();
        }
        catch (Exception e) {
            throw ExceptionUtils.toSqlState(e);
        }
        return updateCount;
    }

    protected void postUpdateActions() {
        if (this.parsedStatement.getUseDatabase() != null) {
            this.localSettings.setDatabase(this.parsedStatement.getUseDatabase());
        }
        if (this.parsedStatement.getRoles() != null) {
            this.connection.getClient().setDBRoles(this.parsedStatement.getRoles());
            this.localSettings.setDBRoles(this.parsedStatement.getRoles());
        }
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
        this.closeCurrentResultSet();
        for (ResultSetImpl resultSet : this.resultSets) {
            if (resultSet == null || resultSet.isClosed()) continue;
            try {
                resultSet.close();
            }
            catch (Exception e) {
                LOG.error("Failed to close result set", (Throwable)e);
            }
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.ensureOpen();
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.ensureOpen();
        if (max < 0) {
            throw new SQLException("max should be a  positive integer.");
        }
        this.maxFieldSize = max;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.ensureOpen();
        return (int)this.getLargeMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.setLargeMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.ensureOpen();
        this.escapeProcessingEnabled = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.ensureOpen();
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.ensureOpen();
        this.queryTimeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        if (this.closed) {
            return;
        }
        try (QueryResponse response = (QueryResponse)this.connection.client.query(String.format("KILL QUERY%sWHERE query_id = '%s'", this.connection.onCluster ? " ON CLUSTER " + this.connection.cluster + " " : " ", this.lastQueryId), this.connection.getDefaultQuerySettings()).get();){
            LOG.debug("Query {} was killed by {}", (Object)this.lastQueryId, (Object)response.getQueryId());
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.ensureOpen();
        this.parsedStatement = this.connection.getSqlParser().parsedStatement(sql);
        this.currentUpdateCount = -1L;
        this.currentResultSet = null;
        if (this.parsedStatement.isHasResultSet()) {
            this.currentResultSet = this.executeQueryImpl(sql, this.localSettings);
            return true;
        }
        this.currentUpdateCount = this.executeUpdateImpl(sql, this.localSettings);
        this.postUpdateActions();
        return false;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.ensureOpen();
        return this.currentResultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.ensureOpen();
        return (int)this.getLargeUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.ensureOpen();
        return this.getMoreResults(1);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.ensureOpen();
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw new SQLException("Invalid fetch direction: " + direction + ". Should be one of ResultSet.FETCH_FORWARD, ResultSet.FETCH_REVERSE, or ResultSet.FETCH_UNKNOWN");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.ensureOpen();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.ensureOpen();
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.ensureOpen();
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.ensureOpen();
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.ensureOpen();
        this.batch.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ensureOpen();
        this.batch.clear();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.executeBatchImpl().stream().mapToInt(i -> i).toArray();
    }

    private List<Integer> executeBatchImpl() throws SQLException {
        this.ensureOpen();
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (String sql : this.batch) {
            results.add(this.executeUpdate(sql));
        }
        return results;
    }

    @Override
    public ConnectionImpl getConnection() throws SQLException {
        return this.connection;
    }

    public QuerySettings getLocalSettings() {
        return this.localSettings;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (this.currentResultSet != null && current != 2) {
            this.currentResultSet.close();
        }
        this.currentResultSet = null;
        this.currentUpdateCount = -1L;
        return false;
    }

    @Override
    public String enquoteLiteral(String val) throws SQLException {
        return SQLUtils.enquoteLiteral((String)val);
    }

    @Override
    public String enquoteIdentifier(String identifier, boolean alwaysQuote) throws SQLException {
        return SQLUtils.enquoteIdentifier((String)identifier, (boolean)alwaysQuote);
    }

    @Override
    public boolean isSimpleIdentifier(String identifier) throws SQLException {
        return SQLUtils.isSimpleIdentifier((String)identifier);
    }

    @Override
    public String enquoteNCharLiteral(String val) throws SQLException {
        if (val == null) {
            throw new NullPointerException();
        }
        return "N" + SQLUtils.enquoteLiteral((String)val);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.ensureOpen();
        this.isPoolable = poolable;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.isPoolable;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.ensureOpen();
        this.closeOnCompletion = true;
    }

    public void onResultSetClosed(ResultSetImpl resultSet) throws SQLException {
        if (resultSet != null) {
            this.resultSets.remove(resultSet);
        }
        if (this.closeOnCompletion && this.resultSets.isEmpty() && (this.currentResultSet == null || this.currentResultSet.isClosed())) {
            this.closed = true;
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.closeOnCompletion;
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.ensureOpen();
        return this.currentUpdateCount;
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.ensureOpen();
        this.maxRows = max;
        if (max > 0L) {
            this.localSettings.setOption(ClientConfigProperties.serverSetting((String)"max_result_rows"), (Object)this.maxRows);
            this.localSettings.setOption(ClientConfigProperties.serverSetting((String)"result_overflow_mode"), (Object)"break");
        } else {
            this.localSettings.setOption(ClientConfigProperties.serverSetting((String)"max_result_rows"), (Object)Long.MAX_VALUE);
            this.localSettings.setOption(ClientConfigProperties.serverSetting((String)"result_overflow_mode"), (Object)"break");
        }
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        this.ensureOpen();
        return this.maxRows;
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        return this.executeBatchImpl().stream().mapToLong(Integer::longValue).toArray();
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        this.parsedStatement = this.connection.getSqlParser().parsedStatement(sql);
        long updateCount = this.executeUpdateImpl(sql, this.localSettings);
        this.postUpdateActions();
        return updateCount;
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeLargeUpdate(sql);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeLargeUpdate(sql);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeLargeUpdate(sql);
    }

    public String getLastQueryId() {
        return this.lastQueryId;
    }
}

