/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.jdbc.internal.ClickHouseLexer;
import com.clickhouse.jdbc.internal.ClickHouseParser;
import com.clickhouse.jdbc.internal.ClickHouseParserBaseListener;
import com.clickhouse.jdbc.internal.ParsedPreparedStatement;
import com.clickhouse.jdbc.internal.ParsedStatement;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.IterativeParseTreeWalker;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlParser {
    private static final Logger LOG = LoggerFactory.getLogger(SqlParser.class);

    public ParsedStatement parsedStatement(String sql) {
        ParsedStatement parserListener = new ParsedStatement();
        this.walkSql(sql, parserListener);
        return parserListener;
    }

    public ParsedPreparedStatement parsePreparedStatement(String sql) {
        ParsedPreparedStatement parserListener = new ParsedPreparedStatement();
        this.walkSql(sql, parserListener);
        return parserListener;
    }

    private ClickHouseParser walkSql(String sql, ClickHouseParserBaseListener listener) {
        CodePointCharStream charStream = CharStreams.fromString((String)sql);
        ClickHouseLexer lexer = new ClickHouseLexer((CharStream)charStream);
        ClickHouseParser parser = new ClickHouseParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new ParserErrorListener());
        ClickHouseParser.QueryStmtContext parseTree = parser.queryStmt();
        IterativeParseTreeWalker.DEFAULT.walk((ParseTreeListener)listener, (ParseTree)parseTree);
        return parser;
    }

    private static class ParserErrorListener
    extends BaseErrorListener {
        private ParserErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            LOG.warn("SQL syntax error at line: " + line + ", pos: " + charPositionInLine + ", " + msg);
        }
    }
}

