/*
 * Decompiled with CFR 0.152.
 */
package com.clivern.kafka;

import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;

public class Configs {
    private Properties properties;

    public Configs() {
        this.properties = new Properties();
    }

    public Configs(Properties defaults) {
        this.properties = defaults;
    }

    public String get(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public String get(String key) {
        return this.properties.getProperty(key);
    }

    public void put(String key, Object value) {
        this.properties.put(key, value);
    }

    public void set(String key, String value) {
        this.properties.put(key, value);
    }

    public Set<String> getKeys() {
        return this.properties.stringPropertyNames();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public static Configs fromFile(String filePath) throws IOException {
        FileReader reader = new FileReader(filePath);
        Properties p = new Properties();
        p.load(reader);
        return new Configs(p);
    }

    public static Configs fromMap(HashMap<String, String> map) {
        Configs config = new Configs();
        for (String key : map.keySet()) {
            config.set(key, map.get(key));
        }
        return config;
    }
}

