/*
 * Decompiled with CFR 0.152.
 */
package com.clivern.kafka.event;

import com.clivern.kafka.event.Message;
import com.clivern.kafka.event.Observer;
import com.clivern.kafka.event.PublisherInterface;
import com.clivern.kafka.exception.MissingEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MessagePublisher
implements PublisherInterface {
    private HashMap<String, List<Observer>> observers = new HashMap();

    @Override
    public void attach(String event, Observer observer) {
        this.observers.putIfAbsent(event, new ArrayList());
        this.observers.get(event).add(observer);
    }

    @Override
    public void notify(String event, Message message) throws MissingEvent {
        if (this.observers.get(event) == null) {
            throw new MissingEvent(String.format("Event %s is missing", event));
        }
        for (Observer observer : this.observers.get(event)) {
            observer.trigger(message);
        }
    }
}

