/*
 * Decompiled with CFR 0.152.
 */
package com.clivern.wit.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.pmw.tinylog.Configurator;
import org.pmw.tinylog.Level;
import org.pmw.tinylog.writers.ConsoleWriter;
import org.pmw.tinylog.writers.FileWriter;
import org.pmw.tinylog.writers.Writer;

public class Config {
    protected Map<String, String> configs = new HashMap<String, String>();

    public Boolean loadPropertiesFile(String path) throws IOException {
        Properties prop = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream(path);
            prop.load(input);
            for (String key : prop.stringPropertyNames()) {
                String value = prop.getProperty(key);
                this.configs.put(key, value);
            }
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public Boolean storePropertiesFile(String path) throws IOException {
        Properties prop = new Properties();
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(path);
            for (String key : this.configs.keySet()) {
                prop.setProperty(key, this.configs.get(key));
            }
            prop.store(output, null);
            return true;
        }
        catch (IOException io) {
            return false;
        }
    }

    public void set(String key, String value) {
        this.configs.put(key, value);
    }

    public String get(String key, String defaultValue) {
        if (this.configs.containsKey(key)) {
            return this.configs.get(key);
        }
        return defaultValue;
    }

    public Map<String, String> getAll() {
        return this.configs;
    }

    public void configLogger() {
        HashMap<String, Level> logLevels = new HashMap<String, Level>();
        logLevels.put("trace", Level.TRACE);
        logLevels.put("debug", Level.DEBUG);
        logLevels.put("info", Level.INFO);
        logLevels.put("warning", Level.WARNING);
        logLevels.put("error", Level.ERROR);
        if (this.get("logging_log_type", "file").equals("file")) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(this.get("logging_current_date_format", "yyyy-MM-dd"));
            Date date = new Date();
            String logFileName = this.get("logging_file_format", "current_date").equals("current_date") ? dateFormat.format(date) + ".log" : this.get("logging_file_format", "current_date") + ".log";
            Configurator.defaultConfig().writer((Writer)new FileWriter(this.get("logging_file_path", "src/main/java/resources/") + logFileName, this.get("logging_buffered", "false").equals("true"), this.get("logging_append", "true").equals("true"))).level(logLevels.containsKey(this.get("logging_level", "debug")) ? (Level)logLevels.get(this.get("logging_level", "debug")) : Level.INFO).activate();
        } else if (this.get("logging_log_type", "file").equals("both")) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(this.get("logging_current_date_format", "yyyy-MM-dd"));
            Date date = new Date();
            String logFileName = this.get("logging_file_format", "current_date").equals("current_date") ? dateFormat.format(date) + ".log" : this.get("logging_file_format", "current_date") + ".log";
            Configurator.defaultConfig().writer((Writer)new ConsoleWriter()).addWriter((Writer)new FileWriter(this.get("logging_file_path", "src/main/java/resources/") + logFileName)).level(logLevels.containsKey(this.get("logging_level", "debug")) ? (Level)logLevels.get(this.get("logging_level", "debug")) : Level.INFO).activate();
        } else {
            Configurator.defaultConfig().writer((Writer)new ConsoleWriter()).level(logLevels.containsKey(this.get("logging_level", "debug")) ? (Level)logLevels.get(this.get("logging_level", "debug")) : Level.INFO).activate();
        }
    }
}

