/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.api.query;

import com.cloudant.client.api.query.Selector;
import com.cloudant.client.api.query.Sort;
import com.cloudant.client.internal.query.InternalIndex;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JsonIndex
extends InternalIndex<Definition, Field> {
    private JsonIndex() {
        super("json");
        this.def = new Definition();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends com.cloudant.client.internal.query.Builder<JsonIndex, Definition, Builder, Field> {
        private Builder() {
        }

        @Override
        protected JsonIndex newInstance() {
            return new JsonIndex();
        }

        @Override
        protected Builder returnThis() {
            return this;
        }

        @Override
        public Builder name(String indexName) {
            return (Builder)super.name(indexName);
        }

        @Override
        public Builder designDocument(String designDocumentId) {
            return (Builder)super.designDocument(designDocumentId);
        }

        @Override
        public Builder partialFilterSelector(Selector selector) {
            return (Builder)super.partialFilterSelector(selector);
        }

        public Builder asc(String ... fieldNames) {
            return (Builder)super.fields(this.fieldNamesToFieldList(Sort.Order.ASC, fieldNames));
        }

        public Builder desc(String ... fieldNames) {
            return (Builder)super.fields(this.fieldNamesToFieldList(Sort.Order.DESC, fieldNames));
        }

        private List<Field> fieldNamesToFieldList(Sort.Order order, String ... fieldNames) {
            ArrayList<Field> fields = new ArrayList<Field>(fieldNames.length);
            for (String fieldName : fieldNames) {
                fields.add(new Field(fieldName, order));
            }
            return fields;
        }
    }

    @JsonAdapter(value=FieldAdapter.class)
    public static class Field
    extends Sort {
        private Field(String name, Sort.Order order) {
            super(name, order);
        }

        private static class FieldAdapter
        implements JsonSerializer<Field>,
        JsonDeserializer<Field> {
            private static final Type SORT_ORDER = new TypeToken<Sort.Order>(){}.getType();

            private FieldAdapter() {
            }

            public Field deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject fieldObject = json.getAsJsonObject();
                Field field = null;
                for (Map.Entry fieldEntry : fieldObject.entrySet()) {
                    field = new Field((String)fieldEntry.getKey(), (Sort.Order)((Object)context.deserialize((JsonElement)fieldEntry.getValue(), SORT_ORDER)));
                }
                return field;
            }

            public JsonElement serialize(Field src, Type typeOfSrc, JsonSerializationContext context) {
                if (src.getOrder() != null) {
                    JsonObject field = new JsonObject();
                    field.add(src.getName(), context.serialize((Object)src.getOrder()));
                    return field;
                }
                return new JsonPrimitive(src.getName());
            }
        }
    }

    static class Definition
    extends com.cloudant.client.internal.query.Definition<Field> {
        Definition() {
        }
    }
}

