/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.api.query;

import com.cloudant.client.api.query.Selector;
import com.cloudant.client.api.query.Type;
import com.cloudant.client.internal.query.InternalIndex;
import com.cloudant.client.internal.query.NamedField;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TextIndex
extends InternalIndex<Definition, Field> {
    private TextIndex() {
        super("text");
        this.def = new Definition();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDefaultField() {
        return ((Definition)this.def).default_field.toString();
    }

    public String getAnalyzer() {
        return ((Definition)this.def).analyzer.toString();
    }

    public boolean getIndexArrayLengths() {
        return ((Definition)this.def).index_array_lengths;
    }

    public static class Builder
    extends com.cloudant.client.internal.query.Builder<TextIndex, Definition, Builder, Field> {
        private Builder() {
        }

        @Override
        protected Builder returnThis() {
            return this;
        }

        @Override
        public Builder name(String indexName) {
            return (Builder)super.name(indexName);
        }

        @Override
        public Builder designDocument(String designDocumentId) {
            return (Builder)super.designDocument(designDocumentId);
        }

        @Override
        public Builder partialFilterSelector(Selector selector) {
            return (Builder)super.partialFilterSelector(selector);
        }

        @Override
        protected TextIndex newInstance() {
            return new TextIndex();
        }

        public Builder defaultField(boolean enabled, String analyzer) {
            ((Definition)((TextIndex)this.instance).def).default_field = new JsonObject();
            ((Definition)((TextIndex)this.instance).def).default_field.addProperty("enabled", Boolean.valueOf(enabled));
            ((Definition)((TextIndex)this.instance).def).default_field.add("analyzer", new Gson().toJsonTree((Object)analyzer));
            return this;
        }

        public Builder analyzer(String analyzer) {
            ((Definition)((TextIndex)this.instance).def).analyzer = (JsonElement)new Gson().fromJson(analyzer, JsonElement.class);
            return this;
        }

        public Builder indexArrayLengths(boolean indexArrayLengths) {
            ((Definition)((TextIndex)this.instance).def).index_array_lengths = indexArrayLengths;
            return this;
        }

        public Builder string(String ... fieldNames) {
            return (Builder)super.fields(this.fieldNamesToFieldList(Type.STRING, fieldNames));
        }

        public Builder number(String ... fieldNames) {
            return (Builder)super.fields(this.fieldNamesToFieldList(Type.NUMBER, fieldNames));
        }

        public Builder bool(String ... fieldNames) {
            return (Builder)super.fields(this.fieldNamesToFieldList(Type.BOOLEAN, fieldNames));
        }

        private List<Field> fieldNamesToFieldList(Type type, String ... fieldNames) {
            ArrayList<Field> fields = new ArrayList<Field>(fieldNames.length);
            for (String fieldName : fieldNames) {
                fields.add(new Field(fieldName, type));
            }
            return fields;
        }
    }

    static class Definition
    extends com.cloudant.client.internal.query.Definition<Field> {
        @SerializedName(value="analyzer", alternate={"default_analyzer"})
        private JsonElement analyzer;
        private JsonObject default_field;
        private Boolean index_array_lengths = null;

        Definition() {
        }
    }

    private static class FieldAdapter
    implements JsonDeserializer<Field> {
        private static final java.lang.reflect.Type TEXT_FIELD = new TypeToken<Type>(){}.getType();

        private FieldAdapter() {
        }

        public Field deserialize(JsonElement json, java.lang.reflect.Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject fieldObject = json.getAsJsonObject();
            Field field = null;
            for (Map.Entry fieldEntry : fieldObject.entrySet()) {
                field = new Field((String)fieldEntry.getKey(), (Type)((Object)context.deserialize((JsonElement)fieldEntry.getValue(), TEXT_FIELD)));
            }
            return field;
        }
    }

    @JsonAdapter(value=FieldAdapter.class)
    public static class Field
    extends NamedField {
        private Type type;

        private Field(String name, Type type) {
            super(name);
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Field field = (Field)o;
            return this.type == field.type;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }
    }
}

