/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.internal.views;

import com.cloudant.client.api.views.ViewMultipleRequest;
import com.cloudant.client.api.views.ViewResponse;
import com.cloudant.client.internal.views.ViewQueryParameters;
import com.cloudant.client.internal.views.ViewRequester;
import com.cloudant.client.internal.views.ViewResponseImpl;
import com.cloudant.http.Http;
import com.cloudant.http.HttpConnection;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ViewMultipleRequester<K, V>
implements ViewMultipleRequest<K, V> {
    private final List<ViewQueryParameters<K, V>> requestParameters = new ArrayList<ViewQueryParameters<K, V>>();

    @Override
    public List<ViewResponse<K, V>> getViewResponses() throws IOException {
        JsonArray queries = new JsonArray();
        ViewQueryParameters<K, V> viewQueryParameters = null;
        for (ViewQueryParameters<K, V> params : this.requestParameters) {
            if (viewQueryParameters == null) {
                viewQueryParameters = params;
            }
            queries.add(params.asJson());
        }
        JsonObject queryJson = new JsonObject();
        queryJson.add("queries", (JsonElement)queries);
        HttpConnection post = Http.POST((URI)viewQueryParameters.getViewURIBuilder().build(), (String)"application/json");
        post.setRequestBody(queryJson.toString());
        JsonObject jsonResponse = ViewRequester.executeRequestWithResponseAsJson(viewQueryParameters, post);
        ArrayList<ViewResponse<K, V>> responses = new ArrayList<ViewResponse<K, V>>();
        JsonArray jsonResponses = jsonResponse.getAsJsonArray("results");
        if (jsonResponses != null) {
            int index = 0;
            for (ViewQueryParameters<K, V> params : this.requestParameters) {
                JsonObject response = jsonResponses.get(index).getAsJsonObject();
                responses.add(new ViewResponseImpl<K, V>(params, response, null));
                ++index;
            }
            return responses;
        }
        return Collections.emptyList();
    }

    public void add(ViewQueryParameters<K, V> viewQueryParameters) {
        this.requestParameters.add(viewQueryParameters);
    }
}

