/*
 * Copyright (c) 2015 IBM Corp. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package com.cloudant.client.api.views;

/**
 * Parent interface of all types of view request builders.
 *
 * @param <RB> the implementing RequestBuilder type
 * @since 2.0.0
 */
public interface RequestBuilder<RB> {

    /**
     * @return this request builder to allow chained composition of parameters
     * @since 2.0.0
     */
    RB returnThis();

}
