/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.api.query;

import com.cloudant.client.api.query.Field;
import com.cloudant.client.api.query.Index;
import com.cloudant.client.api.query.JsonIndex;
import com.cloudant.client.api.query.TextIndex;
import com.cloudant.client.internal.query.ListableIndex;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;

public class Indexes {
    private JsonArray indexes;

    public List<TextIndex> textIndexes() {
        return this.listIndexType("text", TextIndex.class);
    }

    public List<JsonIndex> jsonIndexes() {
        return this.listIndexType("json", JsonIndex.class);
    }

    public List<Index<Field>> allIndexes() {
        ArrayList<Index<Field>> indexesOfAnyType = new ArrayList<Index<Field>>();
        indexesOfAnyType.addAll(this.listIndexType(null, ListableIndex.class));
        return indexesOfAnyType;
    }

    private <T extends Index> List<T> listIndexType(String type, Class<T> modelType) {
        ArrayList<Object> indexesOfType = new ArrayList<Object>();
        Gson g = new Gson();
        for (JsonElement index : this.indexes) {
            JsonObject indexDefinition;
            JsonElement indexType;
            if (!index.isJsonObject() || (indexType = (indexDefinition = index.getAsJsonObject()).get("type")) == null || !indexType.isJsonPrimitive()) continue;
            JsonPrimitive indexTypePrimitive = indexType.getAsJsonPrimitive();
            if (type != null && (!indexTypePrimitive.isString() || !indexTypePrimitive.getAsString().equals(type))) continue;
            indexesOfType.add(g.fromJson((JsonElement)indexDefinition, modelType));
        }
        return indexesOfType;
    }
}

