/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.api;

import com.cloudant.client.api.CloudantClient;
import com.cloudant.client.api.Database;
import com.cloudant.client.api.model.SearchResult;
import com.cloudant.client.internal.DatabaseURIHelper;
import com.cloudant.client.org.lightcouch.internal.CouchDbUtil;
import com.cloudant.http.Http;
import com.cloudant.http.HttpConnection;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class Search {
    private static final Logger log = Logger.getLogger(Search.class.getCanonicalName());
    private Integer limit;
    private boolean includeDocs = false;
    private String bookmark;
    private CloudantClient client;
    private DatabaseURIHelper databaseHelper;
    private final String partitionKey;

    Search(CloudantClient client, Database db, String partitionKey, String searchIndexId) {
        CouchDbUtil.assertNotEmpty(searchIndexId, "searchIndexId");
        this.client = client;
        this.partitionKey = partitionKey;
        String search = searchIndexId;
        this.databaseHelper = new DatabaseURIHelper(db.getDBUri()).partition(partitionKey);
        if (searchIndexId.contains("/")) {
            String[] v = searchIndexId.split("/");
            ((DatabaseURIHelper)((DatabaseURIHelper)((DatabaseURIHelper)this.databaseHelper.path("_design")).path(v[0])).path("_search")).path(v[1]);
        } else {
            this.databaseHelper.path(search);
        }
    }

    public InputStream queryForStream(String query) {
        this.key(query);
        URI uri = this.databaseHelper.build();
        HttpConnection get = Http.GET((URI)uri);
        get.requestProperties.put("Accept", "application/json");
        return this.client.couchDbClient.executeToInputStream(get);
    }

    public <T> List<T> query(String query, Class<T> classOfT) {
        ArrayList<T> arrayList;
        InputStream instream = null;
        ArrayList<T> result = new ArrayList<T>();
        try {
            instream = this.queryForStream(query);
            InputStreamReader reader = new InputStreamReader(instream, "UTF-8");
            JsonObject json = new JsonParser().parse((Reader)reader).getAsJsonObject();
            if (json.has("rows")) {
                if (!this.includeDocs) {
                    log.warning("includeDocs set to false and attempting to retrieve doc. null object will be returned");
                }
                for (JsonElement e : json.getAsJsonArray("rows")) {
                    result.add(CouchDbUtil.jsonToObject(this.client.getGson(), e, "doc", classOfT));
                }
            } else {
                log.warning("No ungrouped result available. Use queryGroups() if grouping set");
            }
            arrayList = result;
        }
        catch (UnsupportedEncodingException e1) {
            try {
                throw new RuntimeException(e1);
            }
            catch (Throwable throwable) {
                CouchDbUtil.close(instream);
                throw throwable;
            }
        }
        CouchDbUtil.close(instream);
        return arrayList;
    }

    public <T> Map<String, List<T>> queryGroups(String query, Class<T> classOfT) {
        LinkedHashMap linkedHashMap;
        InputStream instream = null;
        try {
            instream = this.queryForStream(query);
            InputStreamReader reader = new InputStreamReader(instream, "UTF-8");
            JsonObject json = new JsonParser().parse((Reader)reader).getAsJsonObject();
            LinkedHashMap result = new LinkedHashMap();
            if (json.has("groups")) {
                for (JsonElement e : json.getAsJsonArray("groups")) {
                    String groupName = e.getAsJsonObject().get("by").getAsString();
                    ArrayList<T> orows = new ArrayList<T>();
                    if (!this.includeDocs) {
                        log.warning("includeDocs set to false and attempting to retrieve doc. null object will be returned");
                    }
                    for (JsonElement rows : e.getAsJsonObject().getAsJsonArray("rows")) {
                        orows.add(CouchDbUtil.jsonToObject(this.client.getGson(), rows, "doc", classOfT));
                    }
                    result.put(groupName, orows);
                }
            } else {
                log.warning("No grouped results available. Use query() if non grouped query");
            }
            linkedHashMap = result;
        }
        catch (UnsupportedEncodingException e1) {
            try {
                throw new RuntimeException(e1);
            }
            catch (Throwable throwable) {
                CouchDbUtil.close(instream);
                throw throwable;
            }
        }
        CouchDbUtil.close(instream);
        return linkedHashMap;
    }

    public <T> SearchResult<T> querySearchResult(String query, Class<T> classOfT) {
        SearchResult searchResult;
        InputStream instream = null;
        try {
            instream = this.queryForStream(query);
            InputStreamReader reader = new InputStreamReader(instream, "UTF-8");
            JsonObject json = new JsonParser().parse((Reader)reader).getAsJsonObject();
            SearchResult sr = new SearchResult();
            sr.setTotalRows(CouchDbUtil.getAsLong(json, "total_rows"));
            sr.setBookmark(CouchDbUtil.getAsString(json, "bookmark"));
            if (json.has("rows")) {
                sr.setRows(this.getRows(json.getAsJsonArray("rows"), sr, classOfT));
            } else if (json.has("groups")) {
                this.setGroups(json.getAsJsonArray("groups"), sr, classOfT);
            }
            if (json.has("counts")) {
                sr.setCounts(this.getFieldsCounts(json.getAsJsonObject("counts").entrySet()));
            }
            if (json.has("ranges")) {
                sr.setRanges(this.getFieldsCounts(json.getAsJsonObject("ranges").entrySet()));
            }
            searchResult = sr;
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CouchDbUtil.close(instream);
                throw throwable;
            }
        }
        CouchDbUtil.close(instream);
        return searchResult;
    }

    public Search limit(Integer limit) {
        this.limit = limit;
        this.databaseHelper.query("limit", this.limit);
        return this;
    }

    public Search bookmark(String bookmark) {
        this.bookmark = bookmark;
        this.databaseHelper.query("bookmark", this.bookmark);
        return this;
    }

    public Search sort(String sortJson) {
        CouchDbUtil.assertNotEmpty(sortJson, "sort");
        this.databaseHelper.query("sort", sortJson);
        return this;
    }

    public Search groupField(String fieldName, boolean isNumber) {
        CouchDbUtil.assertNotEmpty(fieldName, "fieldName");
        if (isNumber) {
            this.databaseHelper.query("group_field", fieldName + "<number>");
        } else {
            this.databaseHelper.query("group_field", fieldName);
        }
        return this;
    }

    public Search groupLimit(int limit) {
        this.databaseHelper.query("group_limit", limit);
        return this;
    }

    public Search groupSort(String groupsortJson) {
        CouchDbUtil.assertNotEmpty(groupsortJson, "groupsortJson");
        this.databaseHelper.query("group_sort", groupsortJson);
        return this;
    }

    public Search ranges(String rangesJson) {
        CouchDbUtil.assertNotEmpty(rangesJson, "rangesJson");
        this.databaseHelper.query("ranges", rangesJson);
        return this;
    }

    public Search counts(String[] countsfields) {
        assert (countsfields.length > 0);
        JsonArray countsJsonArray = new JsonArray();
        for (String countsfield : countsfields) {
            JsonPrimitive element = new JsonPrimitive(countsfield);
            countsJsonArray.add((JsonElement)element);
        }
        this.databaseHelper.query("counts", countsJsonArray);
        return this;
    }

    @Deprecated
    public Search drillDown(String fieldName, String fieldValue) {
        CouchDbUtil.assertNotEmpty(fieldName, "fieldName");
        CouchDbUtil.assertNotEmpty(fieldValue, "fieldValue");
        JsonArray drillDownArray = new JsonArray();
        JsonPrimitive fieldNamePrimitive = new JsonPrimitive(fieldName);
        drillDownArray.add((JsonElement)fieldNamePrimitive);
        JsonPrimitive fieldValuePrimitive = new JsonPrimitive(fieldValue);
        drillDownArray.add((JsonElement)fieldValuePrimitive);
        this.databaseHelper.query("drilldown", drillDownArray, false);
        return this;
    }

    public Search drillDown(String fieldName, String ... fieldValues) {
        CouchDbUtil.assertNotEmpty(fieldName, "fieldName");
        CouchDbUtil.assertNotEmpty(fieldValues, "fieldValues");
        JsonArray drillDownArray = new JsonArray();
        JsonPrimitive fieldNamePrimitive = new JsonPrimitive(fieldName);
        drillDownArray.add((JsonElement)fieldNamePrimitive);
        for (String fieldValue : fieldValues) {
            JsonPrimitive fieldValuePrimitive = new JsonPrimitive(fieldValue);
            drillDownArray.add((JsonElement)fieldValuePrimitive);
        }
        this.databaseHelper.query("drilldown", drillDownArray, false);
        return this;
    }

    public Search stale(boolean stale) {
        if (stale) {
            this.databaseHelper.query("stale", "ok");
        }
        return this;
    }

    public Search includeDocs(Boolean includeDocs) {
        this.includeDocs = includeDocs;
        this.databaseHelper.query("include_docs", this.includeDocs);
        return this;
    }

    private void key(String query) {
        this.databaseHelper.query("q", query);
    }

    private Map<String, Map<String, Long>> getFieldsCounts(Set<Map.Entry<String, JsonElement>> fldset) {
        HashMap<String, Map<String, Long>> map = new HashMap<String, Map<String, Long>>();
        for (Map.Entry<String, JsonElement> fld : fldset) {
            String field = fld.getKey();
            HashMap ovalues = new HashMap();
            if (fld.getValue().isJsonObject()) {
                Set values = fld.getValue().getAsJsonObject().entrySet();
                for (Map.Entry value : values) {
                    ovalues.put(value.getKey(), ((JsonElement)value.getValue()).getAsLong());
                }
            }
            map.put(field, ovalues);
        }
        return map;
    }

    private <T> List<SearchResult.SearchResultRow> getRows(JsonArray jsonrows, SearchResult<T> sr, Class<T> classOfT) {
        ArrayList<SearchResult.SearchResultRow> ret = new ArrayList<SearchResult.SearchResultRow>();
        for (JsonElement e : jsonrows) {
            SearchResult.SearchResultRow row = new SearchResult.SearchResultRow(sr);
            JsonObject oe = e.getAsJsonObject();
            row.setId(oe.get("id").getAsString());
            row.setOrder(CouchDbUtil.jsonToObject(this.client.getGson(), e, "order", Object[].class));
            row.setFields(CouchDbUtil.jsonToObject(this.client.getGson(), e, "fields", classOfT));
            if (this.includeDocs) {
                row.setDoc(CouchDbUtil.jsonToObject(this.client.getGson(), e, "doc", classOfT));
            }
            ret.add(row);
        }
        return ret;
    }

    private <T> void setGroups(JsonArray jsongroups, SearchResult<T> sr, Class<T> classOfT) {
        for (JsonElement e : jsongroups) {
            SearchResult.SearchResultGroup group = new SearchResult.SearchResultGroup(sr);
            JsonObject oe = e.getAsJsonObject();
            group.setBy(oe.get("by").getAsString());
            group.setTotalRows(oe.get("total_rows").getAsLong());
            group.setRows(this.getRows(oe.getAsJsonArray("rows"), sr, classOfT));
            sr.getGroups().add(group);
        }
    }
}

