/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.api.model;

import com.cloudant.client.api.model.IndexField;
import com.cloudant.client.org.lightcouch.internal.CouchDbUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;

public class FindByIndexOptions {
    private Integer limit;
    private Integer skip;
    private List<IndexField> sort = new ArrayList<IndexField>();
    private List<String> fields = new ArrayList<String>();
    private Integer readQuorum;
    private JsonElement useIndex = null;

    public FindByIndexOptions limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public FindByIndexOptions skip(Integer skip) {
        this.skip = skip;
        return this;
    }

    public FindByIndexOptions readQuorum(Integer readQuorum) {
        this.readQuorum = readQuorum;
        return this;
    }

    public FindByIndexOptions sort(IndexField sort) {
        CouchDbUtil.assertNotNull(sort, "sort");
        this.sort.add(sort);
        return this;
    }

    public FindByIndexOptions fields(String field) {
        CouchDbUtil.assertNotNull(field, "field");
        this.fields.add(field);
        return this;
    }

    public FindByIndexOptions useIndex(String designDocument) {
        CouchDbUtil.assertNotNull(designDocument, "designDocument");
        this.useIndex = new JsonPrimitive(designDocument);
        return this;
    }

    public FindByIndexOptions useIndex(String designDocument, String indexName) {
        CouchDbUtil.assertNotNull(designDocument, "designDocument");
        CouchDbUtil.assertNotNull(indexName, "indexName");
        JsonArray index = new JsonArray();
        index.add((JsonElement)new JsonPrimitive(designDocument));
        index.add((JsonElement)new JsonPrimitive(indexName));
        this.useIndex = index;
        return this;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public List<IndexField> getSort() {
        return this.sort;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getSkip() {
        return this.skip;
    }

    public Integer getReadQuorum() {
        return this.readQuorum;
    }

    public String getUseIndex() {
        return this.useIndex != null ? this.useIndex.toString() : null;
    }
}

