/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.org.lightcouch;

import com.cloudant.client.api.model.MetaInformation;
import com.cloudant.client.api.scheduler.SchedulerDocsResponse;
import com.cloudant.client.api.scheduler.SchedulerJobsResponse;
import com.cloudant.client.internal.DatabaseURIHelper;
import com.cloudant.client.internal.URIBase;
import com.cloudant.client.internal.util.DeserializationTypes;
import com.cloudant.client.org.lightcouch.CouchDatabase;
import com.cloudant.client.org.lightcouch.CouchDbConfig;
import com.cloudant.client.org.lightcouch.CouchDbException;
import com.cloudant.client.org.lightcouch.CouchDbProperties;
import com.cloudant.client.org.lightcouch.DocumentConflictException;
import com.cloudant.client.org.lightcouch.NoDocumentException;
import com.cloudant.client.org.lightcouch.PreconditionFailedException;
import com.cloudant.client.org.lightcouch.Replication;
import com.cloudant.client.org.lightcouch.Replicator;
import com.cloudant.client.org.lightcouch.Response;
import com.cloudant.client.org.lightcouch.TooManyRequestsException;
import com.cloudant.client.org.lightcouch.internal.CouchDbUtil;
import com.cloudant.client.org.lightcouch.internal.GsonHelper;
import com.cloudant.http.Http;
import com.cloudant.http.HttpConnection;
import com.cloudant.http.HttpConnectionRequestInterceptor;
import com.cloudant.http.HttpConnectionResponseInterceptor;
import com.cloudant.http.internal.DefaultHttpUrlConnectionFactory;
import com.cloudant.http.internal.interceptors.HttpConnectionInterceptorException;
import com.cloudant.http.internal.ok.OkHelper;
import com.cloudant.http.internal.ok.OkHttpClientHttpUrlConnectionFactory;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import okhttp3.ConnectionPool;
import org.apache.commons.io.IOUtils;

public class CouchDbClient {
    static final Logger log = Logger.getLogger(CouchDbClient.class.getCanonicalName());
    private Gson gson;
    private URI clientUri;
    private List<HttpConnectionRequestInterceptor> requestInterceptors;
    private List<HttpConnectionResponseInterceptor> responseInterceptors;
    private final HttpConnection.HttpUrlConnectionFactory factory;

    CouchDbClient(CouchDbConfig config) {
        CouchDbProperties props = config.getProperties();
        try {
            this.clientUri = props.getCouchDbURL().toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error converting account URL to URI.", e);
        }
        this.gson = GsonHelper.initGson(new GsonBuilder()).create();
        if (OkHelper.isOkUsable()) {
            log.config("Using OkHttp");
            OkHttpClientHttpUrlConnectionFactory factory = new OkHttpClientHttpUrlConnectionFactory();
            int maxConns = props.getMaxConnections();
            if (maxConns > 0) {
                log.config("Setting max connections to " + maxConns);
                ConnectionPool pool = new ConnectionPool(maxConns, 3L, TimeUnit.MINUTES);
                factory.getOkHttpClientBuilder().connectionPool(pool);
            }
            this.factory = factory;
        } else {
            log.config("Using built-in HttpUrlConnection");
            this.factory = new DefaultHttpUrlConnectionFactory();
        }
        if (props.getProxyURL() != null) {
            this.factory.setProxy(props.getProxyURL());
            if (props.getProxyAuthentication() != null) {
                this.factory.setProxyAuthentication(props.getProxyAuthentication());
            }
        }
        this.requestInterceptors = new ArrayList<HttpConnectionRequestInterceptor>();
        this.responseInterceptors = new ArrayList<HttpConnectionResponseInterceptor>();
        if (props.getRequestInterceptors() != null) {
            this.requestInterceptors.addAll(props.getRequestInterceptors());
        }
        if (props.getResponseInterceptors() != null) {
            this.responseInterceptors.addAll(props.getResponseInterceptors());
        }
    }

    public CouchDbClient(CouchDbProperties properties) {
        this(new CouchDbConfig(properties));
    }

    public void shutdown() {
        Response response = this.executeToResponse(Http.DELETE((URI)((URIBase)new URIBase(this.clientUri).path("_session")).build()));
        if (!response.isOk()) {
            log.warning("Error deleting session on client shutdown.");
        }
        this.factory.shutdown();
    }

    public URI getBaseUri() {
        return new URIBase(this.clientUri).getUri();
    }

    public CouchDatabase database(String name, boolean create) {
        return new CouchDatabase(this, name, create);
    }

    @Deprecated
    public void deleteDB(String dbName, String confirm) {
        if (!"delete database".equals(confirm)) {
            throw new IllegalArgumentException("Invalid confirm!");
        }
        this.deleteDB(dbName);
    }

    public void deleteDB(String dbName) {
        CouchDbUtil.assertNotEmpty(dbName, "dbName");
        this.delete(new DatabaseURIHelper(this.getBaseUri(), dbName).getDatabaseUri());
    }

    public void createDB(String dbName) {
        this.createDB(dbName, false);
    }

    public void createPartitionedDB(String dbName) {
        this.createDB(dbName, true);
    }

    private void createDB(String dbName, Boolean partitioned) {
        CouchDbUtil.assertNotEmpty(dbName, "dbName");
        DatabaseURIHelper uriHelper = new DatabaseURIHelper(this.getBaseUri(), dbName);
        if (partitioned.booleanValue()) {
            uriHelper.query("partitioned", true);
        }
        URI uri = uriHelper.build();
        this.executeToResponse(Http.PUT((URI)uri, (String)"application/json"));
        log.info(String.format("Created Database: '%s'", dbName));
    }

    public List<String> getAllDbs() {
        List list;
        InputStream instream = null;
        try {
            instream = this.get(((URIBase)new URIBase(this.clientUri).path("_all_dbs")).build());
            InputStreamReader reader = new InputStreamReader(instream, "UTF-8");
            list = (List)this.getGson().fromJson((Reader)reader, DeserializationTypes.STRINGS);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CouchDbUtil.close(instream);
                throw throwable;
            }
        }
        CouchDbUtil.close(instream);
        return list;
    }

    public String serverVersion() {
        return this.metaInformation().getVersion();
    }

    public MetaInformation metaInformation() {
        MetaInformation metaInformation;
        InputStream instream = null;
        try {
            instream = this.get(this.getBaseUri());
            InputStreamReader reader = new InputStreamReader(instream, "UTF-8");
            metaInformation = (MetaInformation)this.getGson().fromJson((Reader)reader, MetaInformation.class);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CouchDbUtil.close(instream);
                throw throwable;
            }
        }
        CouchDbUtil.close(instream);
        return metaInformation;
    }

    public Replication replication() {
        return new Replication(this);
    }

    public Replicator replicator() {
        return new Replicator(this);
    }

    public SchedulerJobsResponse schedulerJobs() {
        return this.get(((DatabaseURIHelper)((DatabaseURIHelper)new DatabaseURIHelper(this.getBaseUri()).path("_scheduler")).path("jobs")).build(), SchedulerJobsResponse.class);
    }

    public SchedulerDocsResponse schedulerDocs() {
        return this.get(((DatabaseURIHelper)((DatabaseURIHelper)new DatabaseURIHelper(this.getBaseUri()).path("_scheduler")).path("docs")).build(), SchedulerDocsResponse.class);
    }

    public SchedulerDocsResponse.Doc schedulerDoc(String docId) {
        CouchDbUtil.assertNotEmpty(docId, "docId");
        return this.get(((DatabaseURIHelper)((DatabaseURIHelper)((DatabaseURIHelper)((DatabaseURIHelper)new DatabaseURIHelper(this.getBaseUri()).path("_scheduler")).path("docs")).path("_replicator")).path(docId)).build(), SchedulerDocsResponse.Doc.class);
    }

    public List<String> uuids(long count) {
        URI uri = ((URIBase)((URIBase)new URIBase(this.clientUri).path("_uuids")).query("count", count)).build();
        JsonObject json = this.get(uri, JsonObject.class);
        return (List)this.getGson().fromJson(json.get("uuids").toString(), DeserializationTypes.STRINGS);
    }

    public Response executeToResponse(HttpConnection connection) {
        InputStream is = null;
        try {
            is = this.executeToInputStream(connection);
            Response response = CouchDbUtil.getResponse(is, Response.class, this.getGson());
            response.setStatusCode(connection.getConnection().getResponseCode());
            response.setReason(connection.getConnection().getResponseMessage());
            Response response2 = response;
            return response2;
        }
        catch (IOException e) {
            throw new CouchDbException("Error retrieving response code or message.", e);
        }
        finally {
            CouchDbUtil.close(is);
        }
    }

    Response delete(URI uri) {
        HttpConnection connection = Http.DELETE((URI)uri);
        return this.executeToResponse(connection);
    }

    public InputStream get(URI uri) {
        HttpConnection httpConnection = Http.GET((URI)uri);
        return this.executeToInputStream(httpConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(URI uri, Class<T> classType) {
        HttpConnection connection = Http.GET((URI)uri);
        InputStream response = this.executeToInputStream(connection);
        try {
            T t = CouchDbUtil.getResponse(response, classType, this.getGson());
            return t;
        }
        finally {
            CouchDbUtil.close(response);
        }
    }

    InputStream head(URI uri) {
        HttpConnection connection = Http.HEAD((URI)uri);
        return this.executeToInputStream(connection);
    }

    InputStream put(URI uri) {
        return this.put(uri, "application/json");
    }

    InputStream put(URI uri, String contentType) {
        HttpConnection connection = Http.PUT((URI)uri, (String)contentType);
        return this.executeToInputStream(connection);
    }

    Response put(URI uri, InputStream instream, String contentType) {
        HttpConnection connection = Http.PUT((URI)uri, (String)contentType);
        connection.setRequestBody(instream);
        return this.executeToResponse(connection);
    }

    public Response put(URI uri, Object object, boolean newEntity) {
        return this.put(uri, object, newEntity, -1);
    }

    public Response put(URI uri, Object object, boolean newEntity, int writeQuorum) {
        CouchDbUtil.assertNotEmpty(object, "object");
        JsonObject json = this.getGson().toJsonTree(object).getAsJsonObject();
        String id = CouchDbUtil.getAsString(json, "_id");
        String rev = CouchDbUtil.getAsString(json, "_rev");
        if (newEntity) {
            CouchDbUtil.assertNull(rev, "rev");
            id = id == null ? CouchDbUtil.generateUUID() : id;
        } else {
            CouchDbUtil.assertNotEmpty(id, "id");
            CouchDbUtil.assertNotEmpty(rev, "rev");
        }
        CouchDbUtil.assertDocumentTypeId(id);
        URI httpUri = null;
        httpUri = writeQuorum > -1 ? new DatabaseURIHelper(uri).documentUri(id, "w", writeQuorum) : new DatabaseURIHelper(uri).documentUri(id);
        HttpConnection connection = Http.PUT((URI)httpUri, (String)"application/json");
        connection.setRequestBody(json.toString());
        return this.executeToResponse(connection);
    }

    public InputStream post(URI uri, String json) {
        HttpConnection connection = Http.POST((URI)uri, (String)"application/json");
        if (json != null && !json.isEmpty()) {
            connection.setRequestBody(json);
        }
        return this.executeToInputStream(connection);
    }

    public void setGsonBuilder(GsonBuilder gsonBuilder) {
        this.gson = GsonHelper.initGson(gsonBuilder).create();
    }

    public Gson getGson() {
        return this.gson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpConnection execute(HttpConnection connection) {
        connection.connectionFactory = this.factory;
        connection.requestProperties.put("Accept", "application/json");
        connection.responseInterceptors.addAll(this.responseInterceptors);
        connection.requestInterceptors.addAll(this.requestInterceptors);
        InputStream es = null;
        try {
            CouchDbException ex;
            try {
                connection = connection.execute();
            }
            catch (HttpConnectionInterceptorException e) {
                CouchDbException exception;
                if (e.deserialize) {
                    exception = new CouchDbException(connection.getConnection().getResponseMessage(), connection.getConnection().getResponseCode());
                    try {
                        JsonObject errorResponse = (JsonObject)new Gson().fromJson(e.error, JsonObject.class);
                        exception.error = CouchDbUtil.getAsString(errorResponse, "error");
                        exception.reason = CouchDbUtil.getAsString(errorResponse, "reason");
                    }
                    catch (JsonParseException jpe) {
                        exception.error = e.error;
                    }
                } else {
                    exception = new CouchDbException(e.getMessage(), e, e.statusCode);
                    exception.error = e.error;
                    exception.reason = e.reason;
                }
                throw exception;
            }
            int code = connection.getConnection().getResponseCode();
            String response = connection.getConnection().getResponseMessage();
            if (code / 100 == 2) {
                return connection;
            }
            switch (code) {
                case 404: {
                    ex = new NoDocumentException(response);
                    break;
                }
                case 409: {
                    ex = new DocumentConflictException(response);
                    break;
                }
                case 412: {
                    ex = new PreconditionFailedException(response);
                    break;
                }
                case 429: {
                    ex = new TooManyRequestsException(response);
                    break;
                }
                default: {
                    ex = new CouchDbException(response, code);
                }
            }
            es = connection.getConnection().getErrorStream();
            if (es != null) {
                try {
                    byte[] errorResponse = IOUtils.toByteArray((InputStream)es);
                    Class<?> exceptionClass = ex.getClass();
                    try {
                        Gson g = new GsonBuilder().registerTypeAdapter(exceptionClass, (Object)new CouchDbExceptionInstanceCreator(ex)).create();
                        g.fromJson((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(errorResponse), "UTF-8"), exceptionClass);
                    }
                    catch (JsonParseException e) {
                        ex.error = new String(errorResponse, "UTF-8");
                    }
                }
                finally {
                    CouchDbUtil.close(es);
                }
            }
            ex.setUrl(connection.url.toString());
            throw ex;
        }
        catch (IOException ioe) {
            CouchDbException ex = new CouchDbException("Error retrieving server response", ioe);
            ex.setUrl(connection.url.toString());
            throw ex;
        }
    }

    public InputStream executeToInputStream(HttpConnection connection) throws CouchDbException {
        try {
            return this.execute(connection).responseAsInputStream();
        }
        catch (IOException ioe) {
            throw new CouchDbException("Error retrieving server response", ioe);
        }
    }

    private static final class CouchDbExceptionInstanceCreator
    implements InstanceCreator<CouchDbException> {
        private final CouchDbException ex;

        CouchDbExceptionInstanceCreator(CouchDbException ex) {
            this.ex = ex;
        }

        public CouchDbException createInstance(Type type) {
            return this.ex;
        }
    }
}

