/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.org.lightcouch.internal;

import com.cloudant.client.api.model.Permissions;
import com.cloudant.client.org.lightcouch.CouchDbException;
import com.cloudant.http.Http;
import com.cloudant.http.HttpConnection;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;

public final class CouchDbUtil {
    public static final String DESIGN_PREFIX = "_design/";
    public static final String LOCAL_PREFIX = "_local/";

    private CouchDbUtil() {
    }

    public static void assertNotEmpty(Object object, String prefix) throws IllegalArgumentException {
        CouchDbUtil.assertNotNull(object, prefix);
        if (object instanceof String && ((String)object).length() == 0) {
            throw new IllegalArgumentException(String.format("%s may not be empty.", prefix));
        }
    }

    public static void assertNotNull(Object object, String prefix) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(String.format("%s may not be null.", prefix));
        }
    }

    public static void assertNull(Object object, String prefix) throws IllegalArgumentException {
        if (object != null) {
            throw new IllegalArgumentException(String.format("%s should be null.", prefix));
        }
    }

    public static void assertDocumentTypeId(String id) throws IllegalArgumentException {
        boolean invalid = false;
        if (id.startsWith("_")) {
            invalid = id.startsWith(DESIGN_PREFIX) && !DESIGN_PREFIX.equals(id) ? false : !id.startsWith(LOCAL_PREFIX) || LOCAL_PREFIX.equals(id);
        }
        if (invalid) {
            throw new IllegalArgumentException(String.format("%s is not a valid document ID.", id));
        }
    }

    public static void assertValidAttachmentName(String attachmentName) throws IllegalArgumentException {
        if (attachmentName.startsWith("_")) {
            throw new IllegalArgumentException(String.format("%s is not a valid attachment name.", attachmentName));
        }
    }

    public static String generateUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static <T> T jsonToObject(Gson gson, JsonElement elem, String key, Class<T> classType) {
        if (elem != null && !elem.isJsonNull()) {
            JsonElement keyElem = elem.getAsJsonObject().get(key);
            if (keyElem != null && !keyElem.isJsonNull()) {
                return (T)gson.fromJson(elem.getAsJsonObject().get(key), classType);
            }
            return null;
        }
        return null;
    }

    public static String getAsString(JsonObject j, String e) {
        JsonElement element;
        if (j != null && e != null && (element = j.get(e)) != null && !element.isJsonNull()) {
            return element.getAsString();
        }
        return null;
    }

    public static long getAsLong(JsonObject j, String e) {
        return j.get(e) == null ? 0L : j.get(e).getAsLong();
    }

    public static int getAsInt(JsonObject j, String e) {
        return j.get(e) == null ? 0 : j.get(e).getAsInt();
    }

    public static String removeExtension(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf(46));
    }

    public static String streamToString(InputStream in) {
        try {
            String string = IOUtils.toString((InputStream)in, (String)"UTF-8");
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading stream.", e);
        }
        finally {
            CouchDbUtil.close(in);
        }
    }

    public static void close(InputStream response) {
        IOUtils.closeQuietly((InputStream)response);
    }

    public static void close(Closeable c) {
        IOUtils.closeQuietly((Closeable)c);
    }

    public static String getAsString(InputStream response, String e) {
        String string;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(response, "UTF-8");
            string = CouchDbUtil.getAsString(new JsonParser().parse((Reader)reader).getAsJsonObject(), e);
        }
        catch (UnsupportedEncodingException e1) {
            try {
                throw new RuntimeException(e1);
            }
            catch (Throwable throwable) {
                CouchDbUtil.close(reader);
                CouchDbUtil.close(response);
                throw throwable;
            }
        }
        CouchDbUtil.close(reader);
        CouchDbUtil.close(response);
        return string;
    }

    public static HttpConnection createPost(URI uri, String body, String contentType) {
        HttpConnection connection = Http.POST((URI)uri, (String)"application/json");
        if (body != null) {
            CouchDbUtil.setEntity(connection, body, contentType);
        }
        return connection;
    }

    public static void setEntity(HttpConnection connnection, String body, String contentType) {
        connnection.requestProperties.put("Content-type", contentType);
        connnection.setRequestBody(body);
    }

    public static <T> List<T> getResponseList(InputStream response, Gson gson, Type typeofT) throws CouchDbException {
        List list;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(response, "UTF-8");
            list = (List)gson.fromJson((Reader)reader, typeofT);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CouchDbUtil.close(reader);
                CouchDbUtil.close(response);
                throw throwable;
            }
        }
        CouchDbUtil.close(reader);
        CouchDbUtil.close(response);
        return list;
    }

    public static <T> T getResponse(InputStream response, Class<T> classType, Gson gson) throws CouchDbException {
        Object object;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(response, "UTF-8");
            object = gson.fromJson((Reader)reader, classType);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CouchDbUtil.close(reader);
                CouchDbUtil.close(response);
                throw throwable;
            }
        }
        CouchDbUtil.close(reader);
        CouchDbUtil.close(response);
        return (T)object;
    }

    public static Map<String, EnumSet<Permissions>> getResponseMap(InputStream response, Gson gson, Type typeofT) throws CouchDbException {
        Map map;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(response, "UTF-8");
            map = (Map)gson.fromJson((Reader)reader, typeofT);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CouchDbUtil.close(reader);
                CouchDbUtil.close(response);
                throw throwable;
            }
        }
        CouchDbUtil.close(reader);
        CouchDbUtil.close(response);
        return map;
    }
}

