/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.http.internal.interceptors;

import com.cloudant.http.HttpConnectionInterceptorContext;
import com.cloudant.http.internal.Utils;
import com.cloudant.http.internal.interceptors.CookieInterceptorBase;
import com.cloudant.http.internal.interceptors.HttpConnectionInterceptorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.logging.Level;

public class CookieInterceptor
extends CookieInterceptorBase {
    public CookieInterceptor(String username, String password, String baseURL) {
        super("application/x-www-form-urlencoded", baseURL, "/_session");
        try {
            this.sessionRequestBody = String.format("name=%s&password=%s", URLEncoder.encode(username, "UTF-8"), URLEncoder.encode(password, "UTF-8")).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public HttpConnectionInterceptorContext interceptResponse(HttpConnectionInterceptorContext context) {
        if (this.shouldAttemptCookieRequest.get()) {
            HttpURLConnection connection = context.connection.getConnection();
            try {
                boolean renewCookie = false;
                int statusCode = connection.getResponseCode();
                if (statusCode == 403 || statusCode == 401) {
                    InputStream errorStream = connection.getErrorStream();
                    String errorString = null;
                    if (errorStream != null) {
                        errorString = Utils.collectAndCloseStream(connection.getErrorStream());
                        logger.log(Level.FINE, String.format(Locale.ENGLISH, "Intercepted response %d %s", statusCode, errorString));
                    }
                    switch (statusCode) {
                        case 403: {
                            if (errorString != null && errorString.matches("(?siu).*\\\"error\\\"\\s*:\\s*\\\"credentials_expired\\\".*")) {
                                renewCookie = true;
                                break;
                            }
                            HttpConnectionInterceptorException toThrow = new HttpConnectionInterceptorException(errorString);
                            toThrow.deserialize = errorString != null;
                            throw toThrow;
                        }
                        case 401: {
                            renewCookie = true;
                            break;
                        }
                    }
                    if (renewCookie) {
                        logger.finest("Cookie was invalid. Will attempt to get new cookie.");
                        boolean success = this.requestCookie(context);
                        if (success) {
                            context.replayRequest = true;
                        } else {
                            context.replayRequest = false;
                            this.shouldAttemptCookieRequest.set(false);
                        }
                    }
                } else {
                    this.storeCookiesFromResponse(connection);
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error reading response code or body from request", e);
            }
        }
        return context;
    }
}

