/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.http.internal.interceptors;

import com.cloudant.http.Http;
import com.cloudant.http.HttpConnection;
import com.cloudant.http.HttpConnectionInterceptorContext;
import com.cloudant.http.HttpConnectionRequestInterceptor;
import com.cloudant.http.HttpConnectionResponseInterceptor;
import com.cloudant.http.internal.Utils;
import com.cloudant.http.internal.interceptors.CookieInterceptor;
import java.io.IOException;
import java.io.InputStream;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CookieInterceptorBase
implements HttpConnectionRequestInterceptor,
HttpConnectionResponseInterceptor {
    protected static final Logger logger = Logger.getLogger(CookieInterceptor.class.getCanonicalName());
    byte[] sessionRequestBody;
    private final String sessionRequestMimeType;
    private final CookieManager cookieManager = new CookieManager();
    final AtomicBoolean shouldAttemptCookieRequest = new AtomicBoolean(true);
    private final URL sessionURL;

    CookieInterceptorBase(String sessionRequestMimeType, String baseUrl, String endpoint) {
        this.sessionRequestMimeType = sessionRequestMimeType;
        try {
            baseUrl = baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
            endpoint = endpoint.startsWith("/") ? endpoint : "/" + endpoint;
            this.sessionURL = new URL(String.format("%s%s", baseUrl, endpoint));
        }
        catch (MalformedURLException e) {
            logger.log(Level.SEVERE, "Failed to create URL for session endpoint", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public HttpConnectionInterceptorContext interceptRequest(HttpConnectionInterceptorContext context) {
        HttpURLConnection connection = context.connection.getConnection();
        if (this.cookieManager.getCookieStore().getCookies().isEmpty() && this.shouldAttemptCookieRequest.get() && !this.requestCookie(context)) {
            this.shouldAttemptCookieRequest.set(false);
        }
        if (this.shouldAttemptCookieRequest.get()) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Attempt to add cookie to request.");
                logger.finest("Cookies are stored for URIs: " + this.cookieManager.getCookieStore().getURIs());
            }
            try {
                Map<String, List<String>> requestCookieHeaders = this.cookieManager.get(connection.getURL().toURI(), connection.getRequestProperties());
                for (Map.Entry<String, List<String>> requestCookieHeader : requestCookieHeaders.entrySet()) {
                    List<String> cookies = requestCookieHeader.getValue();
                    if (cookies != null && !cookies.isEmpty()) {
                        connection.setRequestProperty(requestCookieHeader.getKey(), this.listToSemicolonSeparatedString(cookies));
                        continue;
                    }
                    logger.finest("No cookie values to set.");
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Failed to read request properties", e);
            }
            catch (URISyntaxException e) {
                logger.log(Level.SEVERE, "Failed to convert request URL to URI for cookie retrieval.");
            }
        }
        return context;
    }

    @Override
    public HttpConnectionInterceptorContext interceptResponse(HttpConnectionInterceptorContext context) {
        try {
            if (this.shouldAttemptCookieRequest.get()) {
                HttpURLConnection connection = context.connection.getConnection();
                int statusCode = connection.getResponseCode();
                if (statusCode == 401) {
                    boolean success = this.requestCookie(context);
                    if (success) {
                        context.replayRequest = true;
                        Utils.consumeAndCloseStream(connection.getErrorStream());
                        logger.log(Level.FINEST, "Consumed error response");
                    } else {
                        context.replayRequest = false;
                        this.shouldAttemptCookieRequest.set(false);
                    }
                } else {
                    this.storeCookiesFromResponse(connection);
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error reading response code or body from request", e);
        }
        return context;
    }

    protected boolean requestCookie(HttpConnectionInterceptorContext context, URL url, byte[] payload, String mimeType, String accept, OnExecuteCallable onResponseOk) {
        try {
            HttpConnection conn = Http.POST(url, mimeType);
            conn.requestProperties.put("accept", accept);
            conn.setRequestBody(payload);
            conn.requestInterceptors.addAll(context.connection.requestInterceptors);
            conn.requestInterceptors.remove(this);
            conn.responseInterceptors.addAll(context.connection.responseInterceptors);
            conn.responseInterceptors.remove(this);
            HttpConnection connection = conn.execute();
            int responseCode = connection.getConnection().getResponseCode();
            if (responseCode / 100 == 2) {
                return onResponseOk.call(connection);
            }
            String error = Utils.collectAndCloseStream(connection.getConnection().getErrorStream());
            logger.fine(error);
            if (responseCode == 401) {
                logger.log(Level.SEVERE, "Credentials are incorrect for server {0}, cookie authentication will not be attempted again by this interceptor object", url);
            } else {
                logger.log(Level.SEVERE, "Failed to get cookie from server {0}, response code {1}, cookie authentication will not be attempted again", new Object[]{url, responseCode});
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to read cookie response", e);
        }
        return false;
    }

    boolean requestCookie(HttpConnectionInterceptorContext context) {
        return this.requestCookie(context, this.sessionURL, this.sessionRequestBody, this.sessionRequestMimeType, "application/json", new OnExecuteCallable(){

            @Override
            public boolean call(HttpConnection connection) throws IOException {
                if (CookieInterceptorBase.this.sessionHasStarted(connection.responseAsInputStream())) {
                    return CookieInterceptorBase.this.storeCookiesFromResponse(connection.getConnection());
                }
                Utils.consumeAndCloseStream(connection.getConnection().getErrorStream());
                return false;
            }
        });
    }

    private boolean sessionHasStarted(InputStream responseStream) throws IOException {
        String response = Utils.collectAndCloseStream(responseStream);
        return response.matches("(?s)(?i)(?u).*\\\"ok\\\"\\s*:\\s*true.*");
    }

    protected boolean storeCookiesFromResponse(HttpURLConnection connection) {
        try {
            logger.finest("Storing cookie.");
            this.cookieManager.put(connection.getURL().toURI(), connection.getHeaderFields());
            return true;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to read cookie response header", e);
            return false;
        }
        catch (URISyntaxException e) {
            logger.log(Level.SEVERE, "Failed to convert request URL to URI for cookie storage.");
            return false;
        }
    }

    private String listToSemicolonSeparatedString(List<String> cookieStrings) {
        StringBuilder builder = new StringBuilder();
        int index = 0;
        for (String cookieString : cookieStrings) {
            builder.append(cookieString);
            if (++index == cookieStrings.size()) continue;
            builder.append("; ");
        }
        return builder.toString();
    }

    static interface OnExecuteCallable {
        public boolean call(HttpConnection var1) throws IOException;
    }
}

