/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.http.internal.interceptors;

import com.cloudant.http.HttpConnection;
import com.cloudant.http.HttpConnectionInterceptorContext;
import com.cloudant.http.internal.interceptors.CookieInterceptorBase;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;

public class IamCookieInterceptor
extends CookieInterceptorBase {
    private byte[] iamTokenRequestBody;
    private final URL iamServerUrl;

    public IamCookieInterceptor(String apiKey, String baseUrl) {
        super("application/json", baseUrl, "/_iam_session");
        try {
            this.iamServerUrl = new URL(System.getProperty("com.cloudant.client.iamserver", "https://iam.bluemix.net/identity/token"));
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException("IAM server property was not a valid URL", mue);
        }
        String tokenRequestBody = String.format(Locale.ENGLISH, "grant_type=urn:ibm:params:oauth:grant-type:apikey&response_type=cloud_iam&apikey=%s", apiKey);
        try {
            this.iamTokenRequestBody = tokenRequestBody.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String getBearerToken(HttpConnectionInterceptorContext context) {
        AtomicReference<String> iamTokenResponse = new AtomicReference<String>();
        boolean result = super.requestCookie(context, this.iamServerUrl, this.iamTokenRequestBody, "application/x-www-form-urlencoded", "application/json", new StoreBearerCallable(iamTokenResponse));
        if (result) {
            return iamTokenResponse.get();
        }
        return null;
    }

    @Override
    boolean requestCookie(HttpConnectionInterceptorContext context) {
        if (!this.shouldAttemptCookieRequest.get()) {
            return false;
        }
        String token = this.getBearerToken(context);
        if (token == null) {
            return false;
        }
        try {
            this.sessionRequestBody = token.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return super.requestCookie(context);
    }

    private static class StoreBearerCallable
    implements CookieInterceptorBase.OnExecuteCallable {
        final AtomicReference<String> iamTokenResponse;

        StoreBearerCallable(AtomicReference<String> iamTokenResponse) {
            this.iamTokenResponse = iamTokenResponse;
        }

        @Override
        public boolean call(HttpConnection connection) throws IOException {
            this.iamTokenResponse.set(connection.responseAsString());
            return true;
        }
    }
}

