/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.http.interceptors;

import com.cloudant.http.HttpConnectionInterceptorContext;
import com.cloudant.http.HttpConnectionResponseInterceptor;
import com.cloudant.http.internal.Utils;
import com.cloudant.http.internal.interceptors.HttpConnectionInterceptorException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class Replay429Interceptor
implements HttpConnectionResponseInterceptor {
    public static final Replay429Interceptor WITH_DEFAULTS = new Replay429Interceptor(3, 250L);
    private static final String ATTEMPT = "attempt";
    private static final long RETRY_AFTER_CAP = TimeUnit.HOURS.toMillis(1L);
    private static final Logger logger = Logger.getLogger(Replay429Interceptor.class.getName());
    private final long initialSleep;
    private final int numberOfReplays;
    private final boolean preferRetryAfter;

    public Replay429Interceptor(int numberOfReplays, long initialBackoff) {
        this(numberOfReplays, initialBackoff, true);
    }

    public Replay429Interceptor(int numberOfReplays, long initialBackoff, boolean preferRetryAfter) {
        this.numberOfReplays = numberOfReplays;
        this.initialSleep = initialBackoff;
        this.preferRetryAfter = preferRetryAfter;
    }

    @Override
    public HttpConnectionInterceptorContext interceptResponse(HttpConnectionInterceptorContext context) {
        try {
            int attempt;
            HttpURLConnection urlConnection = context.connection.getConnection();
            int code = urlConnection.getResponseCode();
            if (code != 429) {
                return context;
            }
            AtomicInteger attemptCounter = context.getState(this, ATTEMPT, AtomicInteger.class);
            if (attemptCounter == null) {
                attemptCounter = new AtomicInteger();
                context.setState(this, ATTEMPT, attemptCounter);
            }
            if ((attempt = attemptCounter.getAndIncrement()) < this.numberOfReplays && context.connection.getNumberOfRetriesRemaining() > 0) {
                String retryAfter;
                long sleepTime = this.initialSleep * Math.round(Math.pow(2.0, attempt));
                String string = retryAfter = this.preferRetryAfter ? urlConnection.getHeaderField("Retry-After") : null;
                if (retryAfter != null) {
                    try {
                        sleepTime = Long.parseLong(retryAfter) * 1000L;
                        if (sleepTime > RETRY_AFTER_CAP) {
                            sleepTime = RETRY_AFTER_CAP;
                            logger.severe("Server specified Retry-After value in excess of one hour, capping retry.");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        logger.warning("Invalid Retry-After value from server falling back to default backoff.");
                    }
                }
                String errorString = Utils.collectAndCloseStream(urlConnection.getErrorStream());
                logger.warning(errorString + " will retry in " + sleepTime + " ms");
                logger.fine("Too many requests backing off for " + sleepTime + " ms.");
                try {
                    TimeUnit.MILLISECONDS.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    logger.fine("Interrupted during 429 backoff wait.");
                }
                context.replayRequest = true;
                return context;
            }
            return context;
        }
        catch (IOException e) {
            throw new HttpConnectionInterceptorException(e);
        }
    }
}

