/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.http.internal.interceptors;

import com.cloudant.http.Http;
import com.cloudant.http.HttpConnection;
import com.cloudant.http.HttpConnectionInterceptorContext;
import com.cloudant.http.HttpConnectionRequestInterceptor;
import com.cloudant.http.HttpConnectionResponseInterceptor;
import com.cloudant.http.internal.Utils;
import com.cloudant.http.internal.interceptors.HttpConnectionInterceptorException;
import java.io.IOException;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CookieInterceptorBase
implements HttpConnectionRequestInterceptor,
HttpConnectionResponseInterceptor {
    protected static final Logger logger = Logger.getLogger(CookieInterceptorBase.class.getCanonicalName());
    private final URL sessionRequestUrl;
    private final String sessionRequestMimeType;
    private final String sessionStateName = "sessionUuid";
    private final CookieManager cookieManager = new CookieManager();
    private final ReadWriteLock sessionLock = new ReentrantReadWriteLock(true);
    private volatile UUID sessionId = UUID.randomUUID();

    protected CookieInterceptorBase(String baseUrl, String endpoint, String requestMimeType) {
        try {
            baseUrl = baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
            endpoint = endpoint.startsWith("/") ? endpoint : "/" + endpoint;
            this.sessionRequestUrl = new URL(String.format("%s%s", baseUrl, endpoint));
            this.sessionRequestMimeType = requestMimeType != null ? requestMimeType : "application/json";
        }
        catch (MalformedURLException e) {
            logger.log(Level.SEVERE, "Failed to create URL for session endpoint", e);
            throw new RuntimeException(e);
        }
    }

    protected abstract byte[] getSessionRequestPayload(HttpConnectionInterceptorContext var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestCookie(HttpConnectionInterceptorContext context) throws IOException {
        block9: {
            this.sessionLock.readLock().lock();
            try {
                if (!this.sessionId.equals(context.getState(this, "sessionUuid", UUID.class))) break block9;
                this.sessionLock.readLock().unlock();
                this.sessionLock.writeLock().lock();
                try {
                    if (!this.sessionId.equals(context.getState(this, "sessionUuid", UUID.class))) break block9;
                    HttpConnection sessionConn = this.makeSessionRequest(this.sessionRequestUrl, this.getSessionRequestPayload(context), this.sessionRequestMimeType, context);
                    HttpURLConnection sessionUrlConnection = sessionConn.getConnection();
                    try {
                        this.storeCookiesFromResponse(sessionUrlConnection);
                    }
                    finally {
                        Utils.collectAndCloseStream(sessionUrlConnection.getInputStream());
                    }
                    this.sessionId = UUID.randomUUID();
                    context.setState(this, "sessionUuid", this.sessionId);
                }
                finally {
                    this.sessionLock.readLock().lock();
                    this.sessionLock.writeLock().unlock();
                }
            }
            finally {
                this.sessionLock.readLock().unlock();
            }
        }
    }

    HttpConnection makeSessionRequest(URL url, byte[] payload, String contentMimeType, HttpConnectionInterceptorContext context) {
        HttpConnection conn = Http.POST(url, contentMimeType);
        conn.requestProperties.put("accept", "application/json");
        conn.setRequestBody(payload);
        conn.requestInterceptors.addAll(context.connection.requestInterceptors);
        conn.requestInterceptors.remove(this);
        conn.responseInterceptors.addAll(context.connection.responseInterceptors);
        conn.responseInterceptors.remove(this);
        try {
            HttpConnection connection = conn.execute();
            int responseCode = connection.getConnection().getResponseCode();
            if (responseCode / 100 == 2) {
                return connection;
            }
            String error = Utils.collectAndCloseStream(connection.getConnection().getErrorStream());
            logger.fine(error);
            HttpConnectionInterceptorException e = responseCode == 401 ? new HttpConnectionInterceptorException(String.format("Credentials are incorrect for server %s", url)) : new HttpConnectionInterceptorException(String.format("HTTP response error getting session at %s.", url));
            e.statusCode = responseCode;
            throw e;
        }
        catch (IOException e) {
            throw this.wrapIOException("Failed to read server response from ", conn.getConnection(), e);
        }
    }

    @Override
    public HttpConnectionInterceptorContext interceptRequest(HttpConnectionInterceptorContext context) {
        context.setState(this, "sessionUuid", this.sessionId);
        HttpURLConnection connection = context.connection.getConnection();
        try {
            if (this.cookieManager.getCookieStore().getCookies().isEmpty()) {
                this.requestCookie(context);
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Attempt to add cookie to request.");
                logger.finest("Cookies are stored for URIs: " + this.cookieManager.getCookieStore().getURIs());
            }
            Map<String, List<String>> requestCookieHeaders = this.cookieManager.get(connection.getURL().toURI(), connection.getRequestProperties());
            for (Map.Entry<String, List<String>> requestCookieHeader : requestCookieHeaders.entrySet()) {
                List<String> cookies = requestCookieHeader.getValue();
                if (cookies != null && !cookies.isEmpty()) {
                    connection.setRequestProperty(requestCookieHeader.getKey(), this.listToSemicolonSeparatedString(cookies));
                    continue;
                }
                logger.finest("No cookie values to set.");
            }
        }
        catch (IOException e) {
            throw this.wrapIOException("Failed to read stored cookies for", connection, e);
        }
        catch (URISyntaxException e) {
            logger.log(Level.SEVERE, "Failed to convert request URL to URI for cookie retrieval.");
        }
        return context;
    }

    @Override
    public HttpConnectionInterceptorContext interceptResponse(HttpConnectionInterceptorContext context) {
        HttpURLConnection connection = context.connection.getConnection();
        try {
            int statusCode = connection.getResponseCode();
            boolean renew = this.shouldRenew(connection, statusCode);
            if (!renew && statusCode == 401) {
                renew = true;
                Utils.consumeAndCloseStream(connection.getErrorStream());
            } else {
                this.storeCookiesFromResponse(connection);
            }
            if (renew) {
                this.requestCookie(context);
                context.replayRequest = true;
            }
        }
        catch (IOException e) {
            throw this.wrapIOException("Failed to read HTTP response code or body from", connection, e);
        }
        return context;
    }

    protected boolean shouldRenew(HttpURLConnection connection, int statusCode) {
        return false;
    }

    private void storeCookiesFromResponse(HttpURLConnection connection) {
        try {
            logger.finest("Storing cookie.");
            this.cookieManager.put(connection.getURL().toURI(), connection.getHeaderFields());
        }
        catch (IOException e) {
            throw this.wrapIOException("Failed to read cookie response header from", connection, e);
        }
        catch (URISyntaxException e) {
            logger.log(Level.SEVERE, "Failed to convert request URL to URI for cookie storage.");
        }
    }

    private String listToSemicolonSeparatedString(List<String> cookieStrings) {
        StringBuilder builder = new StringBuilder();
        int index = 0;
        for (String cookieString : cookieStrings) {
            builder.append(cookieString);
            if (++index == cookieStrings.size()) continue;
            builder.append("; ");
        }
        return builder.toString();
    }

    HttpConnectionInterceptorException wrapIOException(String msg, HttpURLConnection conn, IOException e) {
        String errorMsg = conn == null ? msg : msg + " " + conn.getURL().toString();
        return new HttpConnectionInterceptorException(new IOException(errorMsg, e));
    }
}

