/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloudant.spring.boot;

import com.cloudant.client.api.ClientBuilder;
import com.cloudant.client.api.CloudantClient;
import com.cloudant.client.api.Database;
import com.ibm.cloudant.spring.boot.CloudantConfigurationProperties;
import java.net.URL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={CloudantConfigurationProperties.class})
public class CloudantAutoConfiguration {
    @Autowired
    private CloudantConfigurationProperties config;

    @Bean
    @ConditionalOnMissingBean
    public ClientBuilder clientBuilder() {
        ClientBuilder builder = ClientBuilder.url((URL)this.config.getUrl()).username(this.config.getUsername()).password(this.config.getPassword());
        return builder;
    }

    @Bean
    @ConditionalOnMissingBean
    public CloudantClient client(ClientBuilder builder) {
        return builder.build();
    }

    @Bean
    @ConditionalOnProperty(name={"cloudant.db"})
    public Database database(CloudantClient client) {
        Database db = client.database(this.config.getDb(), this.config.getCreateDb());
        return db;
    }
}

