/*
 * Copyright 2010-2012, CloudBees Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.cloudbees.api;

import com.thoughtworks.xstream.annotations.XStreamAlias;

import java.util.Map;

@XStreamAlias("ApplicationCheckSumsResponse")
public class ApplicationCheckSumsResponse {
    Map<String, Long> checkSums;
    String snapshotID;

    public ApplicationCheckSumsResponse() {
    }

    public ApplicationCheckSumsResponse(Map<String, Long> checkSums) {
        this.checkSums = checkSums;
    }

    public Map<String, Long> getCheckSums() {
        return checkSums;
    }

    public void setCheckSums(Map<String, Long> checkSums) {
        this.checkSums = checkSums;
    }

    public String getSnapshotID() {
        return snapshotID;
    }

    public void setSnapshotID(String snapshotID) {
        this.snapshotID = snapshotID;
    }
}
