/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.api;

import com.cloudbees.api.UploadProgress;
import com.cloudbees.api.config.ConfigParameters;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ApplicationDeployArgs {
    public final String appId;
    public final boolean create;
    public final String environment;
    public final String description;
    public final File archiveFile;
    public final File srcFile;
    public final String archiveType;
    public final boolean deltaDeploy;
    public final Map<String, String> parameters;
    public final Map<String, String> variables;
    public final UploadProgress progress;

    private ApplicationDeployArgs(Builder b) {
        this.appId = b.appId;
        this.create = b.create;
        this.environment = b.environment;
        this.description = b.description;
        this.archiveFile = b.archiveFile;
        this.srcFile = b.srcFile;
        this.deltaDeploy = b.deltaDeploy;
        this.archiveType = b.archiveType;
        this.parameters = Collections.unmodifiableMap(b.parameters);
        this.variables = Collections.unmodifiableMap(b.variables);
        this.progress = b.progress;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        String appId;
        boolean create = false;
        String environment;
        String description;
        File archiveFile;
        File srcFile;
        String archiveType;
        boolean deltaDeploy = true;
        Map<String, String> parameters = new HashMap<String, String>();
        Map<String, String> variables = new HashMap<String, String>();
        UploadProgress progress;

        public Builder(String appId) {
            this.appId = appId;
        }

        public String getAppId() {
            return this.appId;
        }

        public Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public Builder asNewApp() {
            this.create = true;
            return this;
        }

        public Builder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        @Deprecated
        public Builder warFile(String file) {
            return this.deployPackage(new File(file), "war");
        }

        public Builder warFile(File file) {
            return this.deployPackage(file, "war");
        }

        @Deprecated
        public Builder earFile(String file) {
            return this.deployPackage(new File(file), "ear");
        }

        public Builder earFile(File file) {
            return this.deployPackage(file, "ear");
        }

        @Deprecated
        public Builder deployPackage(String file, String type) {
            return this.deployPackage(new File(file), type);
        }

        public Builder deployPackage(File file, String type) {
            this.archiveType = type;
            this.archiveFile = file;
            return this;
        }

        @Deprecated
        public Builder srcFile(String srcFile) {
            return this.srcFile(new File(srcFile));
        }

        public Builder srcFile(File srcFile) {
            this.srcFile = srcFile;
            return this;
        }

        public Builder archiveType(String archiveType) {
            this.archiveType = archiveType;
            return this;
        }

        public Builder incrementalDeployment(boolean deltaDeploy) {
            this.deltaDeploy = deltaDeploy;
            return this;
        }

        public Builder withIncrementalDeployment() {
            this.deltaDeploy = true;
            return this;
        }

        public Builder withParam(String name, String value) {
            this.parameters.put(name, value);
            return this;
        }

        public Builder withParams(Map<String, String> params) {
            if (params != null) {
                this.parameters.putAll(params);
            }
            return this;
        }

        public Builder withVar(String name, String value) {
            this.variables.put(name, value);
            return this;
        }

        public Builder withVars(Map<String, String> vars) {
            if (vars != null) {
                this.variables.putAll(vars);
            }
            return this;
        }

        public Builder withConfigs(ConfigParameters config) {
            this.withVars(config.getParameters());
            for (Map.Entry e : config.getRuntimeParameters().entrySet()) {
                this.withParam("runtime." + (String)e.getKey(), (String)e.getValue());
            }
            return this;
        }

        public Builder withProgressFeedback(UploadProgress progress) {
            this.progress = progress;
            return this;
        }

        public ApplicationDeployArgs build() {
            if (this.archiveType == null || this.archiveFile == null) {
                throw new IllegalStateException("no archive was provided");
            }
            return new ApplicationDeployArgs(this);
        }
    }
}

