/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.api;

import com.cloudbees.api.DateHelper;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="ApplicationInfo")
public class ApplicationInfo {
    private String id;
    private String title;
    private String created;
    private String status;
    @XStreamImplicit(itemFieldName="url")
    private List<String> urls;
    Map<String, String> settings;

    public ApplicationInfo(String id, String title, Date created, String status, String[] urls) {
        this.id = id;
        this.title = title;
        this.created = DateHelper.toW3CDateString(created);
        this.status = status;
        this.urls = new ArrayList<String>();
        for (String url : urls) {
            this.urls.add(url);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public Date getCreated() {
        if (this.created == null) {
            return null;
        }
        try {
            return DateHelper.parseW3CDate(this.created);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String getStatus() {
        return this.status;
    }

    public String[] getUrls() {
        if (this.urls == null) {
            this.urls = new ArrayList<String>();
        }
        return this.urls.toArray(new String[0]);
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public void setSettings(Map<String, String> settings) {
        this.settings = settings;
    }
}

