/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.api.config;

import com.cloudbees.api.config.Environment;
import com.cloudbees.api.config.ParameterHolder;
import com.cloudbees.api.config.ParameterSettings;
import com.cloudbees.api.config.ResourceSettings;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="config")
public class ConfigParameters
extends ParameterHolder {
    @XStreamImplicit(itemFieldName="resource")
    private List<ResourceSettings> resources;
    @XStreamImplicit(itemFieldName="env")
    private List<Environment> environments;

    public List<Environment> getEnvironments() {
        if (this.environments == null) {
            this.environments = new ArrayList<Environment>();
        }
        return this.environments;
    }

    public void setEnvironments(List<Environment> environments) {
        this.environments = environments;
    }

    public void setEnvironment(Environment environment) {
        this.deleteEnvironment(environment.getName());
        this.getEnvironments().add(environment);
    }

    public Environment getEnvironment(String env) {
        for (Environment environment : this.getEnvironments()) {
            if (!env.equals(environment.getName())) continue;
            return environment;
        }
        return null;
    }

    public void deleteEnvironment(String name) {
        Iterator<Environment> it = this.getEnvironments().iterator();
        while (it.hasNext()) {
            if (!it.next().getName().equals(name)) continue;
            it.remove();
        }
    }

    public List<ResourceSettings> getResources() {
        if (this.resources == null) {
            this.resources = new ArrayList<ResourceSettings>();
        }
        return this.resources;
    }

    public void setResources(List<ResourceSettings> resources) {
        this.resources = resources;
    }

    public void setResource(ResourceSettings resource) {
        this.deleteResource(resource.getName());
        this.getResources().add(resource);
    }

    public ResourceSettings getResource(String name) {
        for (ResourceSettings resource : this.getResources()) {
            if (!resource.getName().equals(name)) continue;
            return resource;
        }
        return null;
    }

    public void deleteResource(String name) {
        Iterator<ResourceSettings> it = this.getResources().iterator();
        while (it.hasNext()) {
            if (!it.next().getName().equals(name)) continue;
            it.remove();
        }
    }

    private static XStream createXStream() {
        XStream xstream = new XStream(){

            protected MapperWrapper wrapMapper(MapperWrapper next) {
                return new MapperWrapper((Mapper)next){

                    public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                        return definedIn != Object.class && super.shouldSerializeMember(definedIn, fieldName);
                    }
                };
            }
        };
        xstream.setClassLoader(ConfigParameters.class.getClassLoader());
        xstream.processAnnotations(ParameterSettings.class);
        xstream.processAnnotations(ResourceSettings.class);
        xstream.processAnnotations(Environment.class);
        xstream.processAnnotations(ConfigParameters.class);
        xstream.processAnnotations(ParameterHolder.class);
        return xstream;
    }

    public String toXML() {
        return ConfigParameters.createXStream().toXML((Object)this);
    }

    public static ConfigParameters parse(String xml) {
        if (xml == null) {
            return new ConfigParameters();
        }
        return (ConfigParameters)ConfigParameters.createXStream().fromXML(xml);
    }
}

