/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.api.cr;

import com.cloudbees.api.oauth.OauthToken;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import org.codehaus.jackson.Base64Variants;

public abstract class Credential {
    public abstract void authorizeRequest(HttpURLConnection var1) throws IOException;

    public static Credential oauth(String token) {
        try {
            final String authorization = "Bearer " + Base64Variants.MIME_NO_LINEFEEDS.encode(token.getBytes("UTF-8"));
            return new Credential(){

                public void authorizeRequest(HttpURLConnection con) {
                    con.setRequestProperty("Authorization", authorization);
                }
            };
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Credential oauth(OauthToken token) {
        return Credential.oauth(token.accessToken);
    }
}

