/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.api.oauth;

import com.cloudbees.api.BeesClient;
import com.cloudbees.api.BeesClientConfiguration;
import com.cloudbees.api.cr.Capability;
import com.cloudbees.api.cr.Credential;
import com.cloudbees.api.oauth.AbstractOauthToken;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckReturnValue;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OauthToken
extends AbstractOauthToken
implements Cloneable {
    @JsonProperty(value="access_token")
    public String accessToken;
    @JsonProperty(value="refresh_token")
    public String refreshToken;
    @JsonProperty(value="token_type")
    public String tokenType;
    @JsonProperty(value="client_id")
    public String clientId;
    @JsonProperty(value="account")
    private String account;
    @JsonProperty(value="expires_in")
    private Integer expiresIn;
    @JsonProperty(value="scope")
    public String scope;

    public List<String> getScopes() {
        return Arrays.asList(this.scope.split(" "));
    }

    @JsonIgnore
    @CheckReturnValue
    public boolean validateScope(String scope) {
        if (scope == null) {
            return false;
        }
        for (String s : this.getScopes()) {
            if (!s.trim().equals(scope)) continue;
            return true;
        }
        return false;
    }

    @CheckReturnValue
    public boolean validateScopes(String ... scopes) {
        for (String s : scopes) {
            if (!this.validateScope(s)) continue;
            return true;
        }
        return false;
    }

    @CheckReturnValue
    public boolean validateCapability(URL host, Capability cap) {
        return this.validateScope(cap.to(host)) || this.validateScope(cap.toAll());
    }

    public boolean belongsToAccount(String account) {
        return this.account.equals(account);
    }

    public Collection<String> listAccounts() {
        return Collections.singleton(this.account);
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(int expiresIn) {
        this.expiresIn = expiresIn;
    }

    @JsonIgnore
    public boolean isExpired() {
        return this.expiresIn != null && this.expiresIn <= 0;
    }

    public OauthToken clone() {
        try {
            return (OauthToken)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public BeesClient createClient() {
        BeesClientConfiguration config = new BeesClientConfiguration();
        config.setOAuthToken(this.accessToken);
        return new BeesClient(config);
    }

    public BeesClient createClient(BeesClientConfiguration current) {
        BeesClientConfiguration config = new BeesClientConfiguration(current.getServerApiUrl());
        config.setOAuthToken(this.accessToken);
        return new BeesClient(config);
    }

    public Credential asCredential() {
        return Credential.oauth(this);
    }
}

