/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.upload;

import com.cloudbees.utils.ZipHelper;
import com.thoughtworks.xstream.XStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArchiveUtils {
    public static int ENTRY_DELETED = 1;
    public static int ENTRY_UPDATED = 2;
    public static int ENTRY_ADDED = 3;
    private static final String META_INF = "META-INF";
    private static final String DELTA_FILE = "CB-DELTA.xml";

    private ArchiveUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static File createDeltaWarFile(Map<String, Long> existingArchiveCheckSums, File warFile, String tmp) throws IOException {
        Map<String, Integer> deltas = ArchiveUtils.getDeltas(warFile.getAbsolutePath(), existingArchiveCheckSums);
        String tmpDir = ArchiveUtils.makeTmpDir(warFile, tmp);
        ZipFile zipFile = new ZipFile(warFile.getAbsolutePath());
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            Integer delta = deltas.get(entry.getName());
            if (delta == null || delta == ENTRY_DELETED) continue;
            ArchiveUtils.unArchiveZipEntry(tmpDir, zipFile, entry);
        }
        File metaInfDir = new File(tmpDir + META_INF);
        metaInfDir.mkdirs();
        File deltaFile = new File(metaInfDir, DELTA_FILE);
        XStream xstream = new XStream();
        FileOutputStream fos = new FileOutputStream(deltaFile);
        xstream.toXML(deltas, (OutputStream)fos);
        fos.close();
        String deltaDir = warFile.getParent() == null ? "." : warFile.getParent();
        String deltaArchiveFile = deltaDir + "/DELTA-" + warFile.getName();
        ArchiveUtils.archiveDirectory(tmpDir, deltaArchiveFile);
        ArchiveUtils.deleteAll(new File(tmpDir));
        return new File(deltaArchiveFile);
    }

    public static Map<String, Integer> getDeltas(String archiveFile, Map<String, Long> oldCheckSums) throws IOException {
        HashMap<String, Integer> deltas = new HashMap<String, Integer>();
        Map<String, Long> newCheckSums = ArchiveUtils.getCheckSums(archiveFile);
        ConcurrentHashMap<String, Long> checkSumsTmp = new ConcurrentHashMap<String, Long>(oldCheckSums);
        for (Map.Entry<String, Long> entry : newCheckSums.entrySet()) {
            String key = entry.getKey();
            if (checkSumsTmp.get(key) == null) {
                deltas.put(key, ENTRY_ADDED);
                continue;
            }
            if (entry.getValue().longValue() != checkSumsTmp.get(key).longValue()) {
                deltas.put(key, ENTRY_UPDATED);
                checkSumsTmp.remove(key);
                continue;
            }
            checkSumsTmp.remove(key);
        }
        for (String key : checkSumsTmp.keySet()) {
            deltas.put(key, ENTRY_DELETED);
        }
        return deltas;
    }

    public static Map<String, Long> getCheckSums(String archiveFile) throws IOException {
        HashMap<String, Long> checkSums = new HashMap<String, Long>();
        ZipFile zipFile = new ZipFile(archiveFile);
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            checkSums.put(entry.getName(), entry.getCrc());
        }
        return checkSums;
    }

    private static void unArchiveZipEntry(String destinationDirectory, ZipFile zipfile, ZipEntry entry) throws IOException {
        File file = ZipHelper.unzipEntryToFolder(entry, zipfile.getInputStream(entry), new File(destinationDirectory));
        if (entry.getTime() > -1L) {
            file.setLastModified(entry.getTime());
        }
    }

    private static void archiveDirectory(String directory, String archiveFile) throws IOException {
        File archive = new File(archiveFile);
        archive.createNewFile();
        FileOutputStream fileOutputStream = new FileOutputStream(archive);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
        ZipHelper.addDirectoryToZip(new File(directory), new File(directory), null, zipOutputStream);
        zipOutputStream.close();
    }

    private static String makeTmpDir(File file, String tmp) {
        String fileName;
        int idx;
        if (tmp == null) {
            tmp = ".";
        }
        if ((idx = (fileName = file.getName()).lastIndexOf(46)) > -1) {
            fileName = fileName.substring(0, idx);
        }
        if (!tmp.endsWith(File.separator)) {
            tmp = tmp + File.separator;
        }
        tmp = tmp + "tmp" + fileName + File.separator;
        File dir = new File(tmp);
        ArchiveUtils.deleteAll(dir);
        dir.mkdirs();
        return tmp;
    }

    private static void deleteAll(File dir) {
        if (dir.exists()) {
            File[] files;
            if (dir.isDirectory() && (files = dir.listFiles()) != null) {
                for (File f : files) {
                    if (f.isDirectory()) {
                        ArchiveUtils.deleteAll(f);
                        continue;
                    }
                    f.delete();
                }
            }
            dir.delete();
        }
    }
}

