/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.utils;

import com.cloudbees.api.ApplicationConfiguration;
import com.cloudbees.utils.AppConfigParser;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class AppConfigHelper {
    private AppConfigHelper() {
        throw new IllegalAccessError("Utility class");
    }

    public static void load(ApplicationConfiguration applicationConfiguration, InputStream in, String[] environments, String[] implicitEnvironments) {
        InputSource input = new InputSource(in);
        AppConfigHelper.load(applicationConfiguration, input, environments, implicitEnvironments);
    }

    private static void load(ApplicationConfiguration applicationConfiguration, InputSource input, String[] environments, String[] implicitEnvironments) {
        Document doc = AppConfigHelper.readXML(input);
        Element rootElement = doc.getDocumentElement();
        if (rootElement.getNodeName().equals("stax-application") || rootElement.getNodeName().equals("stax-web-app") || rootElement.getNodeName().equals("cloudbees-web-app")) {
            AppConfigParser parser = new AppConfigParser();
            parser.load(applicationConfiguration, doc, environments, implicitEnvironments);
        }
    }

    private static Document readXML(InputSource input) {
        DocumentBuilderFactory dBF = DocumentBuilderFactory.newInstance();
        dBF.setIgnoringComments(true);
        DocumentBuilder builder = null;
        try {
            builder = dBF.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        Document doc = null;
        try {
            doc = builder.parse(input);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return doc;
    }
}

