/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.utils;

import com.cloudbees.utils.NoCloseInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public final class ZipHelper {
    private static int BUFFER = 2048;

    private ZipHelper() {
        throw new IllegalAccessError("Utility class");
    }

    public static void addDirectoryToZip(File directory, File base, String dirPrefix, ZipOutputStream zos) throws IOException {
        if (base == null) {
            base = directory;
        }
        if (dirPrefix == null) {
            dirPrefix = "";
        }
        if (!base.equals(directory)) {
            String dirEntryPath = dirPrefix + directory.getPath().substring(base.getPath().length() + 1).replace('\\', '/');
            ZipEntry dirEntry = new ZipEntry(dirEntryPath.endsWith("/") ? dirEntryPath : dirEntryPath + "/");
            zos.putNextEntry(dirEntry);
        }
        File[] files = directory.listFiles();
        byte[] buffer = new byte[8192];
        int read = 0;
        for (File file : files) {
            if (file.isDirectory()) {
                ZipHelper.addDirectoryToZip(file, base, dirPrefix, zos);
                continue;
            }
            FileInputStream in = new FileInputStream(file);
            ZipEntry entry = new ZipEntry(dirPrefix + file.getPath().substring(base.getPath().length() + 1).replace('\\', '/'));
            entry.setTime(file.lastModified());
            zos.putNextEntry(entry);
            while (-1 != (read = in.read(buffer))) {
                zos.write(buffer, 0, read);
            }
            in.close();
        }
    }

    public static void unzipFile(InputStream fis, ZipEntryHandler zipHandler, boolean closeStream) throws IOException {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
        while ((entry = zis.getNextEntry()) != null) {
            zipHandler.unzip(entry, new NoCloseInputStream(zis));
        }
        if (closeStream) {
            zis.close();
        }
    }

    public static File unzipEntryToFolder(ZipEntry entry, InputStream zis, File destFolder) throws IOException {
        int count;
        if (entry.isDirectory()) {
            File destFile = new File(destFolder, entry.getName());
            destFile.mkdirs();
            return destFile;
        }
        byte[] data = new byte[BUFFER];
        File destFile = new File(destFolder, entry.getName());
        File parentFolder = destFile.getParentFile();
        if (!parentFolder.exists()) {
            parentFolder.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(destFile);
        BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER);
        while ((count = zis.read(data, 0, BUFFER)) != -1) {
            dest.write(data, 0, count);
        }
        dest.flush();
        dest.close();
        return destFile;
    }

    public static interface ZipEntryHandler {
        public void unzip(ZipEntry var1, InputStream var2) throws IOException;
    }
}

