/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.sdk.extensibility;

import com.cloudbees.sdk.extensibility.ExtensionImplementation;
import com.cloudbees.sdk.extensibility.ExtensionLoaderModule;
import com.cloudbees.sdk.extensibility.ExtensionPoint;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.jvnet.hudson.annotation_indexer.Index;
import org.jvnet.hudson.annotation_indexer.Indexed;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionFinder
extends AbstractModule {
    private final ClassLoader cl;
    private static final Logger LOGGER = Logger.getLogger(ExtensionFinder.class.getName());

    public ExtensionFinder(ClassLoader cl) {
        this.cl = cl;
    }

    protected void configure() {
        try {
            HashSet<Class> seen = new HashSet<Class>();
            for (Class a : Index.list(ExtensionImplementation.class, (ClassLoader)this.cl, Class.class)) {
                if (!a.isAnnotationPresent(Indexed.class)) {
                    throw new AssertionError((Object)(a + " has @ExtensionImplementation but not @Indexed"));
                }
                for (Class c : Index.list(a.asSubclass(Annotation.class), (ClassLoader)this.cl, Class.class)) {
                    if (!seen.add(c)) continue;
                    for (Class ext : this.listExtensionPoint(c, new HashSet<Class>())) {
                        this.bind(c, ext);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    protected <T> void bind(Class<? extends T> impl, Class<T> extensionPoint) {
        ExtensionLoaderModule<? extends T> lm = this.createLoaderModule(extensionPoint);
        lm.init(impl, extensionPoint);
        this.install((Module)lm);
    }

    protected <T> ExtensionLoaderModule<T> createLoaderModule(Class<T> extensionPoint) {
        ExtensionPoint ep = extensionPoint.getAnnotation(ExtensionPoint.class);
        if (ep != null && ep.loader() != ExtensionLoaderModule.Default.class) {
            try {
                return ep.loader().newInstance();
            }
            catch (InstantiationException e) {
                throw (Error)new InstantiationError().initCause(e);
            }
            catch (IllegalAccessException e) {
                throw (Error)new IllegalAccessError().initCause(e);
            }
        }
        return new ExtensionLoaderModule.Default();
    }

    private Set<Class> listExtensionPoint(Class e, Set<Class> result) {
        Class s;
        if (e.isAnnotationPresent(ExtensionPoint.class)) {
            result.add(e);
        }
        if ((s = e.getSuperclass()) != null) {
            this.listExtensionPoint(s, result);
        }
        for (Class<?> c : e.getInterfaces()) {
            this.listExtensionPoint(c, result);
        }
        return result;
    }
}

