/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps.impl;

import com.cloudbees.groovy.cps.CpsDefaultGroovyMethods;
import com.google.common.base.Objects;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClassImpl;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaMethod;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.reflection.GeneratedMetaMethod;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.metaclass.MetaClassRegistryImpl;
import org.codehaus.groovy.runtime.metaclass.MetaMethodIndex;
import org.codehaus.groovy.runtime.metaclass.NewInstanceMetaMethod;
import org.codehaus.groovy.util.AbstractConcurrentMapBase;
import org.codehaus.groovy.util.FastArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DGMPatcher {
    private final Field MetaClassImpl_myNewMetaMethods = this.field(MetaClassImpl.class, "myNewMetaMethods");
    private final Field MetaClassImpl_newGroovyMethodsSet = this.field(MetaClassImpl.class, "newGroovyMethodsSet");
    private final Field MetaClassImpl_metaMethodIndex = this.field(MetaClassImpl.class, "metaMethodIndex");
    private final Field ClassInfo_dgmMetaMethods = this.field(ClassInfo.class, "dgmMetaMethods");
    private final Field ClassInfo_newMetaMethods = this.field(ClassInfo.class, "newMetaMethods");
    private final Field ClassInfo_globalClassSet = this.field(ClassInfo.class, "globalClassSet");
    private final Field ClassInfoSet_segments = this.field(AbstractConcurrentMapBase.class, "segments");
    private final Field Segment_table = this.field(AbstractConcurrentMapBase.Segment.class, "table");
    private final Map<Key, MetaMethod> overrides = new HashMap<Key, MetaMethod>();

    DGMPatcher(List<MetaMethod> methods) {
        for (MetaMethod m : methods) {
            MetaMethod old = this.overrides.put(new Key(m), m);
            if (old == null) continue;
            throw new IllegalStateException("duplication between " + m + " and " + old);
        }
    }

    void patch() {
        MetaClassRegistry r = GroovySystem.getMetaClassRegistry();
        this.patch(r);
        try {
            this.patch(this.ClassInfo_globalClassSet.get(null));
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    private Object patch(Object o) {
        block7: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        block9: {
                                            block8: {
                                                block6: {
                                                    if (!(o instanceof MetaClassRegistryImpl)) break block6;
                                                    MetaClassRegistryImpl r = (MetaClassRegistryImpl)o;
                                                    this.patch(r.getInstanceMethods());
                                                    this.patch(r.getStaticMethods());
                                                    break block7;
                                                }
                                                if (!(o instanceof ClassInfo.ClassInfoSet)) break block8;
                                                ClassInfo.ClassInfoSet cis = (ClassInfo.ClassInfoSet)o;
                                                this.patch(cis, this.ClassInfoSet_segments);
                                                break block7;
                                            }
                                            if (!(o instanceof AbstractConcurrentMapBase.Segment)) break block9;
                                            AbstractConcurrentMapBase.Segment s = (AbstractConcurrentMapBase.Segment)o;
                                            this.patch(s, this.Segment_table);
                                            break block7;
                                        }
                                        if (!(o instanceof ClassInfo)) break block10;
                                        ClassInfo ci = (ClassInfo)o;
                                        this.patch(ci, this.ClassInfo_dgmMetaMethods);
                                        this.patch(ci, this.ClassInfo_newMetaMethods);
                                        this.patch(ci.getStrongMetaClass());
                                        this.patch(ci.getWeakMetaClass());
                                        break block7;
                                    }
                                    if (!(o instanceof MetaClassImpl)) break block11;
                                    MetaClassImpl mc = (MetaClassImpl)o;
                                    this.patch(mc, this.MetaClassImpl_myNewMetaMethods);
                                    this.patch(mc.getMethods());
                                    this.patch(mc, this.MetaClassImpl_newGroovyMethodsSet);
                                    this.patch(mc, this.MetaClassImpl_metaMethodIndex);
                                    break block7;
                                }
                                if (!(o instanceof MetaMethodIndex)) break block12;
                                MetaMethodIndex mmi = (MetaMethodIndex)o;
                                for (MetaMethodIndex.Entry e : mmi.getTable()) {
                                    if (e == null) continue;
                                    e.methods = this.patch(e.methods);
                                    e.methodsForSuper = this.patch(e.methodsForSuper);
                                    e.staticMethods = this.patch(e.staticMethods);
                                }
                                mmi.clearCaches();
                                break block7;
                            }
                            if (!(o instanceof GeneratedMetaMethod)) break block13;
                            GeneratedMetaMethod gm = (GeneratedMetaMethod)o;
                            MetaMethod replace = this.overrides.get(new Key((MetaMethod)gm));
                            if (replace != null) {
                                return replace;
                            }
                            break block7;
                        }
                        if (!(o instanceof Object[])) break block14;
                        Object[] a = (Object[])o;
                        for (int i = 0; i < a.length; ++i) {
                            a[i] = this.patch(a[i]);
                        }
                        break block7;
                    }
                    if (!(o instanceof List)) break block15;
                    List l = (List)o;
                    ListIterator<Object> i = l.listIterator();
                    while (i.hasNext()) {
                        Object y;
                        Object x = i.next();
                        if (x == (y = this.patch(x))) continue;
                        i.set(y);
                    }
                    break block7;
                }
                if (!(o instanceof FastArray)) break block16;
                FastArray a = (FastArray)o;
                for (int i = 0; i < a.size(); ++i) {
                    Object y;
                    Object x = a.get(i);
                    if (x == (y = this.patch(x))) continue;
                    a.set(i, y);
                }
                break block7;
            }
            if (!(o instanceof Set)) break block7;
            Set s = (Set)o;
            for (Object x : s.toArray()) {
                Object y = this.patch(x);
                if (x == y) continue;
                s.remove(x);
                s.add(y);
            }
        }
        return o;
    }

    private void patch(Object o, Field f) {
        try {
            Object x = f.get(o);
            Object y = this.patch(x);
            if (x != y) {
                f.set(o, y);
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    private Field field(Class<?> owner, String field) {
        try {
            Field f = owner.getDeclaredField(field);
            f.setAccessible(true);
            return f;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static void init() {
    }

    static {
        ArrayList<MetaMethod> methods = new ArrayList<MetaMethod>();
        for (CachedMethod m : ReflectionCache.getCachedClass(CpsDefaultGroovyMethods.class).getMethods()) {
            CachedClass[] paramTypes;
            if (!m.isStatic() || !m.isPublic() || (paramTypes = m.getParameterTypes()).length <= 0) continue;
            methods.add((MetaMethod)new NewInstanceMetaMethod(m));
        }
        new DGMPatcher(methods).patch();
    }

    static final class Key {
        final Class declaringClass;
        final String name;
        final Class[] nativeParamTypes;

        Key(Class declaringClass, String name, Class[] nativeParamTypes) {
            this.declaringClass = declaringClass;
            this.name = name;
            this.nativeParamTypes = nativeParamTypes;
        }

        Key(MetaMethod m) {
            this(m.getDeclaringClass().getTheClass(), m.getName(), m.getNativeParameterTypes());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equal((Object)this.declaringClass, (Object)key.declaringClass) && Objects.equal((Object)this.name, (Object)key.name) && Arrays.equals(this.nativeParamTypes, key.nativeParamTypes);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.declaringClass, this.name, Arrays.hashCode(this.nativeParamTypes)});
        }

        public String toString() {
            return this.declaringClass.getName() + "." + this.name + Arrays.toString(this.nativeParamTypes);
        }
    }
}

