/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps.impl;

import com.cloudbees.groovy.cps.Continuation;
import com.cloudbees.groovy.cps.Env;
import com.cloudbees.groovy.cps.LValue;
import com.cloudbees.groovy.cps.LValueBlock;
import com.cloudbees.groovy.cps.Next;
import com.cloudbees.groovy.cps.impl.ContinuationGroup;
import com.cloudbees.groovy.cps.impl.ReferenceStackTrace;
import com.cloudbees.groovy.cps.impl.SourceLocation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class StaticFieldBlock
extends LValueBlock {
    private final Class lhs;
    private final String name;
    private final SourceLocation loc;
    private static final long serialVersionUID = 1L;

    public StaticFieldBlock(SourceLocation loc, Class lhs, String name) {
        this.lhs = lhs;
        this.name = name;
        this.loc = loc;
    }

    @Override
    public Next evalLValue(Env e, Continuation k) {
        return k.receive(new LValueImpl(e));
    }

    class LValueImpl
    extends ContinuationGroup
    implements LValue {
        private final Env e;
        private static final long serialVersionUID = 1L;

        public LValueImpl(Env e) {
            this.e = e;
        }

        private Field resolve() {
            try {
                Field f = StaticFieldBlock.this.lhs.getField(StaticFieldBlock.this.name);
                if (Modifier.isStatic(f.getModifiers())) {
                    f.setAccessible(true);
                    return f;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            return null;
        }

        private Next throwNoSuchFieldError() {
            return this.throwException(this.e, new NoSuchFieldError(StaticFieldBlock.this.lhs.getName() + "." + StaticFieldBlock.this.name), StaticFieldBlock.this.loc, new ReferenceStackTrace());
        }

        @Override
        public Next get(Continuation k) {
            try {
                Field r = this.resolve();
                if (r == null) {
                    return this.throwNoSuchFieldError();
                }
                return k.receive(r.get(null));
            }
            catch (IllegalAccessException t) {
                return this.throwException(this.e, t, StaticFieldBlock.this.loc, new ReferenceStackTrace());
            }
        }

        @Override
        public Next set(Object v, Continuation k) {
            try {
                Field r = this.resolve();
                if (r == null) {
                    return this.throwNoSuchFieldError();
                }
                r.set(null, v);
                return k.receive(null);
            }
            catch (IllegalAccessException t) {
                return this.throwException(this.e, t, StaticFieldBlock.this.loc, new ReferenceStackTrace());
            }
        }
    }
}

