/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.maven.license;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.model.License;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleterDelegate {
    public MavenProject dependency;
    public MavenProject project;

    public CompleterDelegate(MavenProject dependency, MavenProject project) {
        this.dependency = dependency;
        this.project = project;
    }

    public void match(Object criteria, Closure body) {
        if (criteria instanceof Object[]) {
            criteria = Arrays.asList((Object[])criteria);
        }
        if (criteria instanceof String) {
            criteria = Collections.singleton(criteria);
        }
        for (String c : (Collection)criteria) {
            String[] tokens = c.split(":");
            if (tokens.length < 2) {
                throw new IllegalArgumentException("Invalid matcher '" + c + "'. Expecting GROUPID:ARTIFACTID");
            }
            if (!this.matchToken(this.dependency.getGroupId(), tokens[0]) || !this.matchToken(this.dependency.getArtifactId(), tokens[1]) || tokens.length > 2 && !this.matchToken(this.dependency.getVersion(), tokens[2])) continue;
            body.call();
        }
    }

    private boolean matchToken(String actual, String expected) {
        return expected.equals("*") || actual.equals(expected);
    }

    public void rewriteLicense(Collection<License> expected, License to) {
        List actual = this.dependency.getLicenses();
        IllegalStateException error = new IllegalStateException("Expecting " + this.toString(expected) + " but found " + this.toString(actual) + " for dependency " + this.toString(this.dependency));
        if (expected.size() != actual.size()) {
            throw error;
        }
        block0: for (License e : expected) {
            for (License a : actual) {
                if (!e.getName().equals(a.getName())) continue;
                continue block0;
            }
            throw error;
        }
        this.dependency.setLicenses(Collections.singletonList(to));
    }

    public License license(String name, String url) {
        License l = new License();
        l.setName(name);
        l.setUrl(url);
        return l;
    }

    public void accept(String name) {
        ArrayList<License> licenses = new ArrayList<License>(this.dependency.getLicenses());
        for (License lic : licenses) {
            if (!lic.getName().equals(name)) continue;
            this.dependency.setLicenses(new ArrayList<License>(Arrays.asList(lic)));
            return;
        }
        IllegalStateException error = new IllegalStateException("Expecting " + name + " but found " + this.toString(licenses) + " for dependency " + this.toString(this.dependency));
    }

    private String toString(Collection<License> lics) {
        StringBuilder buf = new StringBuilder();
        for (License lic : lics) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(lic.getName());
        }
        return "[" + buf.toString() + "]";
    }

    private String toString(MavenProject p) {
        return p.getGroupId() + ":" + p.getArtifactId() + ":" + p.getVersion();
    }
}

