/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.maven.license;

import com.cloudbees.maven.license.CompleterDelegate;
import com.cloudbees.maven.license.FilterDelegate;
import com.cloudbees.maven.license.GeneratorDelegate;
import com.cloudbees.maven.license.LicenseScript;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.groovy.control.CompilerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessMojo
extends AbstractMojo {
    public MavenProjectHelper projectHelper;
    public MavenProject project;
    public MavenProjectBuilder projectBuilder;
    public ArtifactFactory artifactFactory;
    public ArtifactRepository localRepository;
    public File script;
    public String inlineScript;
    public boolean requireCompleteLicenseInfo;
    public File generateLicenseXml;
    public File generateLicenseHtml;
    public boolean disableCheck;

    public void execute() throws MojoExecutionException {
        if (this.disableCheck) {
            return;
        }
        GroovyShell shell = this.createShell(LicenseScript.class);
        List<LicenseScript> comp = this.parseScripts(this.script, shell);
        if (this.generateLicenseHtml != null && this.generateLicenseXml == null) {
            try {
                this.generateLicenseXml = File.createTempFile("license", "xml");
                this.generateLicenseXml.deleteOnExit();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to generate a temporary file", (Exception)e);
            }
        }
        if (this.generateLicenseXml != null) {
            comp.add((LicenseScript)shell.parse(((Object)((Object)this)).getClass().getResourceAsStream("xmlgen.groovy"), "xmlgen.groovy"));
        }
        if (this.generateLicenseHtml != null) {
            comp.add((LicenseScript)shell.parse(((Object)((Object)this)).getClass().getResourceAsStream("htmlgen.groovy"), "htmlgen.groovy"));
        }
        if (this.inlineScript != null) {
            comp.add((LicenseScript)shell.parse(this.inlineScript, "inlineScript"));
        }
        for (LicenseScript s : comp) {
            s.project = this.project;
            s.mojo = this;
            s.run();
        }
        ArrayList<MavenProject> dependencies = new ArrayList<MavenProject>();
        for (LicenseScript s : comp) {
            s.runCompleter(new CompleterDelegate(this.project, this.project));
        }
        dependencies.add(this.project);
        try {
            HashMap<Artifact, MavenProject> models = new HashMap<Artifact, MavenProject>();
            for (Artifact a : this.project.getArtifacts()) {
                Artifact pom = this.artifactFactory.createProjectArtifact(a.getGroupId(), a.getArtifactId(), a.getVersion());
                MavenProject model = this.projectBuilder.buildFromRepository(pom, this.project.getRemoteArtifactRepositories(), this.localRepository);
                models.put(a, model);
            }
            for (LicenseScript s : comp) {
                s.runFilter(new FilterDelegate(models));
            }
            Iterator itr = models.entrySet().iterator();
            while (itr.hasNext()) {
                MavenProject e = itr.next();
                if (!((Artifact)e.getKey()).isOptional()) continue;
                itr.remove();
            }
            for (MavenProject e : models.values()) {
                for (LicenseScript s : comp) {
                    s.runCompleter(new CompleterDelegate(e, this.project));
                }
            }
            dependencies.addAll(models.values());
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("Failed to parse into dependencies", (Exception)((Object)e));
        }
        if (this.requireCompleteLicenseInfo) {
            ArrayList<MavenProject> missing = new ArrayList<MavenProject>();
            for (MavenProject d : dependencies) {
                if (!d.getLicenses().isEmpty()) continue;
                missing.add(d);
            }
            if (!missing.isEmpty()) {
                StringBuilder buf = new StringBuilder("The following dependencies are missing license information:\n");
                for (MavenProject p : missing) {
                    buf.append("  " + p.getGroupId() + ':' + p.getArtifactId() + ':' + p.getVersion());
                    for (p = p.getParent(); p != null; p = p.getParent()) {
                        buf.append(" -> " + p.getGroupId() + ':' + p.getArtifactId() + ':' + p.getVersion());
                    }
                    buf.append('\n');
                }
                buf.append("\nAdd/update your completion script to fill them, or run with -Dlicense.disableCheck to bypass the check.");
                throw new MojoExecutionException(buf.toString());
            }
        }
        for (LicenseScript s : comp) {
            s.runGenerator(new GeneratorDelegate(dependencies));
        }
    }

    private List<LicenseScript> parseScripts(File src, GroovyShell shell) throws MojoExecutionException {
        ArrayList<LicenseScript> comp = new ArrayList<LicenseScript>();
        if (src != null) {
            try {
                if (src.isDirectory()) {
                    for (File script : src.listFiles()) {
                        comp.add((LicenseScript)shell.parse(script));
                    }
                } else {
                    comp.add((LicenseScript)shell.parse(src));
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to parse the script: " + src, (Exception)e);
            }
        }
        return comp;
    }

    private <T extends Script> GroovyShell createShell(Class<T> baseType) {
        CompilerConfiguration cc = new CompilerConfiguration();
        cc.setScriptBaseClass(baseType.getName());
        return new GroovyShell(((Object)((Object)this)).getClass().getClassLoader(), new Binding(), cc);
    }
}

