/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.syslog;

import com.cloudbees.syslog.Facility;
import com.cloudbees.syslog.MessageFormat;
import com.cloudbees.syslog.Severity;
import com.cloudbees.syslog.util.CachingReference;
import com.cloudbees.syslog.util.ConcurrentDateFormat;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SyslogMessage {
    public static final char SP = ' ';
    public static final char NILVALUE = '-';
    private static final int DEFAULT_CONCURRENCY = 50;
    protected static final ConcurrentDateFormat rfc3339DateFormat;
    protected static final ConcurrentDateFormat rfc3164DateFormat;
    private static CachingReference<String> localhostNameReference;
    private Facility facility;
    private Severity severity;
    private Date timestamp;
    private String hostname;
    private String appName;
    private String procId;
    private String msgId;
    private CharArrayWriter msg;

    public Facility getFacility() {
        return this.facility;
    }

    public void setFacility(Facility facility) {
        this.facility = facility;
    }

    public SyslogMessage withFacility(Facility facility) {
        this.facility = facility;
        return this;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public SyslogMessage withSeverity(Severity severity) {
        this.severity = severity;
        return this;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public SyslogMessage withTimestamp(long timestamp) {
        this.timestamp = new Date(timestamp);
        return this;
    }

    public SyslogMessage withTimestamp(Date timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public SyslogMessage withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public SyslogMessage withAppName(String appName) {
        this.appName = appName;
        return this;
    }

    public String getProcId() {
        return this.procId;
    }

    public void setProcId(String procId) {
        this.procId = procId;
    }

    public SyslogMessage withProcId(String procId) {
        this.procId = procId;
        return this;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public SyslogMessage withMsgId(String msgId) {
        this.msgId = msgId;
        return this;
    }

    public CharArrayWriter getMsg() {
        return this.msg;
    }

    public void setMsg(CharArrayWriter msg) {
        this.msg = msg;
    }

    public SyslogMessage withMsg(CharArrayWriter msg) {
        this.msg = msg;
        return this;
    }

    public SyslogMessage withMsg(final String msg) {
        return this.withMsg(new CharArrayWriter(){
            {
                this.append(msg);
            }
        });
    }

    public String toSyslogMessage(MessageFormat messageFormat) {
        switch (messageFormat) {
            case RFC_3164: {
                return this.toRfc3164SyslogMessage();
            }
            case RFC_5424: {
                return this.toRfc5424SyslogMessage();
            }
        }
        throw new IllegalStateException("Unsupported message format '" + (Object)((Object)messageFormat) + "'");
    }

    public void toSyslogMessage(@Nonnull MessageFormat messageFormat, @Nonnull Writer out) throws IOException {
        switch (messageFormat) {
            case RFC_3164: {
                this.toRfc3164SyslogMessage(out);
                break;
            }
            case RFC_5424: {
                this.toRfc5424SyslogMessage(out);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported message format '" + (Object)((Object)messageFormat) + "'");
            }
        }
    }

    public String toRfc5424SyslogMessage() {
        StringWriter sw = new StringWriter(this.msg == null ? 32 : this.msg.size() + 32);
        try {
            this.toRfc5424SyslogMessage(sw);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return sw.toString();
    }

    public void toRfc5424SyslogMessage(Writer out) throws IOException {
        int pri = this.facility.numericalCode() + this.severity.numericalCode();
        out.write(60);
        out.write(String.valueOf(pri));
        out.write(62);
        out.write(49);
        out.write(32);
        out.write(rfc3339DateFormat.format(this.timestamp == null ? new Date() : this.timestamp));
        out.write(32);
        out.write(this.hostname == null ? localhostNameReference.get() : this.hostname);
        out.write(32);
        this.writeNillableValue(this.appName, out);
        out.write(32);
        this.writeNillableValue(this.procId, out);
        out.write(32);
        this.writeNillableValue(this.msgId, out);
        out.write(32);
        out.write(45);
        if (this.msg != null) {
            out.write(32);
            this.msg.writeTo(out);
        }
    }

    public String toRfc3164SyslogMessage() {
        StringWriter sw = new StringWriter(this.msg == null ? 32 : this.msg.size() + 32);
        try {
            this.toRfc3164SyslogMessage(sw);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return sw.toString();
    }

    public void toRfc3164SyslogMessage(Writer out) throws IOException {
        int pri = this.facility.numericalCode() + this.severity.numericalCode();
        out.write(60);
        out.write(Integer.toString(pri));
        out.write(62);
        out.write(rfc3164DateFormat.format(this.timestamp == null ? new Date() : this.timestamp));
        out.write(32);
        out.write(this.hostname == null ? localhostNameReference.get() : this.hostname);
        out.write(32);
        this.writeNillableValue(this.appName, out);
        if (this.msg != null) {
            out.write(": ");
            this.msg.writeTo(out);
        }
    }

    protected void writeNillableValue(@Nullable String value, @Nonnull Writer out) throws IOException {
        if (value == null) {
            out.write(45);
        } else {
            out.write(value);
        }
    }

    static {
        int concurrency;
        localhostNameReference = new CachingReference<String>(10L, TimeUnit.SECONDS){

            @Override
            protected String newObject() {
                try {
                    return InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    return String.valueOf('-');
                }
            }
        };
        try {
            concurrency = Integer.parseInt(System.getProperty(SyslogMessage.class.getPackage().getName() + ".concurrency", String.valueOf(50)));
        }
        catch (Exception e) {
            concurrency = 50;
        }
        rfc3339DateFormat = new ConcurrentDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US, TimeZone.getTimeZone("GMT"), concurrency);
        rfc3164DateFormat = new ConcurrentDateFormat("MMM dd HH:mm:ss", Locale.US, TimeZone.getDefault(), concurrency);
    }
}

