/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.syslog.sender;

import com.cloudbees.syslog.Facility;
import com.cloudbees.syslog.MessageFormat;
import com.cloudbees.syslog.Severity;
import com.cloudbees.syslog.SyslogMessage;
import com.cloudbees.syslog.sender.SyslogMessageSender;
import com.cloudbees.syslog.util.InternalLogger;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;

public abstract class AbstractSyslogMessageSender
implements SyslogMessageSender {
    protected static final Charset UTF_8 = Charset.forName("UTF-8");
    protected final InternalLogger logger = InternalLogger.getLogger(this.getClass());
    protected String defaultAppName;
    protected Facility defaultFacility = Facility.USER;
    protected String defaultMessageHostname;
    protected Severity defaultSeverity = Severity.INFORMATIONAL;
    protected MessageFormat messageFormat = DEFAULT_SYSLOG_MESSAGE_FORMAT;
    protected final AtomicInteger sendCounter = new AtomicInteger();
    protected final AtomicLong sendDurationInNanosCounter = new AtomicLong();
    protected final AtomicInteger sendErrorCounter = new AtomicInteger();

    @Override
    public void sendMessage(CharArrayWriter message) throws IOException {
        SyslogMessage syslogMessage = new SyslogMessage().withAppName(this.defaultAppName).withFacility(this.defaultFacility).withHostname(this.defaultMessageHostname).withSeverity(this.defaultSeverity).withMsg(message);
        this.sendMessage(syslogMessage);
    }

    @Override
    public void sendMessage(CharSequence message) throws IOException {
        CharArrayWriter writer = new CharArrayWriter();
        writer.append(message);
        this.sendMessage(writer);
    }

    @Override
    public abstract void sendMessage(@Nonnull SyslogMessage var1) throws IOException;

    public String getDefaultAppName() {
        return this.defaultAppName;
    }

    public Facility getDefaultFacility() {
        return this.defaultFacility;
    }

    public MessageFormat getMessageFormat() {
        return this.messageFormat;
    }

    public String getDefaultMessageHostname() {
        return this.defaultMessageHostname;
    }

    public int getSendCount() {
        return this.sendCounter.get();
    }

    public long getSendDurationInMillis() {
        return TimeUnit.MILLISECONDS.convert(this.getSendDurationInNanos(), TimeUnit.NANOSECONDS);
    }

    public long getSendDurationInNanos() {
        return this.sendDurationInNanosCounter.get();
    }

    public int getSendErrorCount() {
        return this.sendErrorCounter.get();
    }

    public Severity getDefaultSeverity() {
        return this.defaultSeverity;
    }

    public void setDefaultAppName(String defaultAppName) {
        this.defaultAppName = defaultAppName;
    }

    public void setDefaultMessageHostname(String defaultHostname) {
        this.defaultMessageHostname = defaultHostname;
    }

    public void setDefaultFacility(Facility defaultFacility) {
        this.defaultFacility = defaultFacility;
    }

    public void setMessageFormat(MessageFormat messageFormat) {
        this.messageFormat = messageFormat;
    }

    public void setDefaultSeverity(Severity defaultSeverity) {
        this.defaultSeverity = defaultSeverity;
    }

    public String toString() {
        return this.getClass().getName() + "{defaultAppName='" + this.defaultAppName + '\'' + ", defaultFacility=" + this.defaultFacility + ", defaultMessageHostname='" + this.defaultMessageHostname + '\'' + ", defaultSeverity=" + (Object)((Object)this.defaultSeverity) + ", messageFormat=" + (Object)((Object)this.messageFormat) + ", sendCounter=" + this.sendCounter + ", sendDurationInNanosCounter=" + this.sendDurationInNanosCounter + ", sendErrorCounter=" + this.sendErrorCounter + '}';
    }
}

