/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.Function;
import com.kenai.jffi.ObjectParameterInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import jnr.ffi.mapper.FromNativeConverter;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.ffi.shaded.org.objectweb.asm.ClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AsmBuilder {
    private final String classNamePath;
    private final ClassVisitor classVisitor;
    private final ObjectNameGenerator functionId = new ObjectNameGenerator("functionAddress");
    private final ObjectNameGenerator contextId = new ObjectNameGenerator("callContext");
    private final ObjectNameGenerator toNativeConverterId = new ObjectNameGenerator("toNativeConverter");
    private final ObjectNameGenerator fromNativeConverterId = new ObjectNameGenerator("fromNativeConverter");
    private final ObjectNameGenerator objectParameterInfoId = new ObjectNameGenerator("objectParameterInfo");
    private final Map<ToNativeConverter, ObjectField> toNativeConverters = new IdentityHashMap<ToNativeConverter, ObjectField>();
    private final Map<FromNativeConverter, ObjectField> fromNativeConverters = new IdentityHashMap<FromNativeConverter, ObjectField>();
    private final Map<ObjectParameterInfo, ObjectField> objectParameterInfo = new HashMap<ObjectParameterInfo, ObjectField>();
    private final Map<CallContext, ObjectField> callContextMap = new HashMap<CallContext, ObjectField>();
    private final Map<Long, ObjectField> functionAddresses = new HashMap<Long, ObjectField>();
    private final List<ObjectField> objectFields = new ArrayList<ObjectField>();

    AsmBuilder(String classNamePath, ClassVisitor classVisitor) {
        this.classNamePath = classNamePath;
        this.classVisitor = classVisitor;
    }

    public String getClassNamePath() {
        return this.classNamePath;
    }

    ClassVisitor getClassVisitor() {
        return this.classVisitor;
    }

    <T> ObjectField addField(Map<T, ObjectField> map, T value, Class klass, ObjectNameGenerator objectNameGenerator) {
        ObjectField field = new ObjectField(objectNameGenerator.generateName(), value, klass);
        this.objectFields.add(field);
        map.put(value, field);
        return field;
    }

    <T> ObjectField getField(Map<T, ObjectField> map, T value, Class klass, ObjectNameGenerator objectNameGenerator) {
        ObjectField field = map.get(value);
        return field != null ? field : this.addField(map, value, klass, objectNameGenerator);
    }

    String getCallContextFieldName(Function function) {
        return this.getField(this.callContextMap, function.getCallContext(), CallContext.class, (ObjectNameGenerator)this.contextId).name;
    }

    String getFunctionAddressFieldName(Function function) {
        return this.getField(this.functionAddresses, Long.valueOf((long)function.getFunctionAddress()), Long.TYPE, (ObjectNameGenerator)this.functionId).name;
    }

    String getFromNativeConverterName(FromNativeConverter converter) {
        return this.getField(this.fromNativeConverters, converter, FromNativeConverter.class, (ObjectNameGenerator)this.fromNativeConverterId).name;
    }

    String getToNativeConverterName(ToNativeConverter converter) {
        return this.getField(this.toNativeConverters, converter, ToNativeConverter.class, (ObjectNameGenerator)this.toNativeConverterId).name;
    }

    String getObjectParameterInfoName(ObjectParameterInfo info) {
        return this.getField(this.objectParameterInfo, info, ObjectParameterInfo.class, (ObjectNameGenerator)this.objectParameterInfoId).name;
    }

    ObjectField[] getObjectFieldArray() {
        return this.objectFields.toArray(new ObjectField[this.objectFields.size()]);
    }

    public static final class ObjectField {
        public final String name;
        public final Object value;
        public final Class klass;

        public ObjectField(String fieldName, Object fieldValue, Class fieldClass) {
            this.name = fieldName;
            this.value = fieldValue;
            this.klass = fieldClass;
        }
    }

    private static final class ObjectNameGenerator {
        private final String baseName;
        private int value;

        ObjectNameGenerator(String baseName) {
            this.baseName = baseName;
            this.value = 0;
        }

        String generateName() {
            return this.baseName + "_" + ++this.value;
        }
    }
}

